#include <memory>

#include "general/AtExit.hh"

#include "genericAPI/SymbolMapper.hh"

static GenericAPI::SymbolMapper* init( )
{
  using namespace General;
  using namespace GenericAPI;

  AtExit::Append( SymbolMapper::OnExit,
		  "GenericAPI::SymbolMapper::OnExit",
			   5 );
  return (SymbolMapper*)NULL;
}

namespace GenericAPI
{
  SymbolMapper*	SymbolMapper::m_symbol_mapper = init( );

  SymbolMapper::
  ~SymbolMapper( )
  {
  }

  void SymbolMapper::
  OnExit( )
  {
    if ( m_symbol_mapper )
    {
      delete m_symbol_mapper;
      m_symbol_mapper = (SymbolMapper*)NULL;
    }
  }

  void SymbolMapper::
  add( const std::string& Symbol, arg_type Arg, func_type Function )
  {
    symbol_table_type::iterator pos
      = m_symbol_table.find( Symbol );

    if ( pos == m_symbol_table.end( ) )
    {
      info i;

      i.s_arg_type = Arg;
      i.s_function = Function;

      m_symbol_table[ Symbol ] = i;
    }
    else
    {
      pos->second.s_arg_type = Arg;
      pos->second.s_function = Function;
    }
  }

  const SymbolMapper::info* SymbolMapper::
  lookup( const std::string& Symbol ) const
  {
    symbol_table_type::const_iterator pos
      = m_symbol_table.find( Symbol );

    if ( pos != m_symbol_table.end( ) )
    {
      return &(pos->second);
    }
    return (info*)NULL;
  }
}
