#ifndef GENERIC_API__LSTAT_POOL_HH
#define GENERIC_API__LSTAT_POOL_HH

#include <list>

#include "general/mutexlock.hh"
#include "general/Singleton.hh"

namespace GenericAPI
{

  class StatBase;

  class StatPool
  {
    // Declare the common methods for Singleton class
    SINGLETON_TS_DECL( StatPool );
  public:
    typedef StatBase info_base_type;
    typedef info_base_type* info_type;
    typedef void (*user_init_cb)( info_type Key );

    static void Cleanup( );

    static info_type StatType( );

    static info_type Request( );
    static void Release( info_type Buffer );
    static void Destroy( info_type Buffer );
    static void UserInitCB( user_init_cb );

  private:
    static MutexLock::lock_type	m_pool_lock;
    static user_init_cb		m_user_init_cb;
    static bool			m_initialized;
  };

  inline void StatPool::
  UserInitCB( user_init_cb UserInitCB )
  {
    m_user_init_cb = UserInitCB;
  }
}

#endif /* GENERIC_API__LSTAT_POOL_HH */
