#ifndef GENERIC_API__STAT_FORK_HH
#define GENERIC_API__STAT_FORK_HH

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <string>

#include "general/Fork.hh"

#include "genericAPI/StatBase.hh"

namespace GenericAPI
{
  class StatFork
    : public StatBase,
      public General::Fork
  {
  public:
    StatFork( );

    virtual StatFork* vnew( ) const;

    virtual std::string Debug( debug_info DebugInfo = STAT_DEBUG_GENERAL ) const;
    virtual void Init( );

    virtual int LStat( const std::string& FileName, stat_buf_type& Buf ) const;
    virtual int LStat( const General::Directory& Dir,
		       const std::string& RelFilename,
		       stat_buf_type& Buf ) const;

    virtual int Stat( const std::string& FileName, stat_buf_type& Buf ) const;
    virtual int Stat( const General::Directory& Dir,
		      const std::string& RelFilename,
		      stat_buf_type& Buf ) const;

    void SetCommand( const std::string& Command );

  protected:
    virtual void evalChild( );
    virtual void evalParent( );

  private:
    std::string		m_cmd;
  };

  inline void StatFork::
  SetCommand( const std::string& Command )
  {
    m_cmd = Command;
  }
}

#endif /* GENERIC_API__STAT_FORK_HH */
