#ifndef GENERIC_API__LOG_HTML_HH
#define GENERIC_API__LOG_HTML_HH

#include "general/Log.hh"

extern "C" {
  struct Tcl_Interp;
}

namespace GenericAPI
{
  //---------------------------------------------------------------------
  /// \brief HTML Logging class
  ///
  //---------------------------------------------------------------------
  class LogHTML
    : public General::Log
  {
  public:
    //-------------------------------------------------------------------
    /// \brief Types of messages.
    //-------------------------------------------------------------------
    enum message_type {
      MT_OK    = 0,	///< Nornal status.
      MT_WARN  = 1,	///< Notable condition which is a non-fatal error.
      MT_ERROR = 2,	///< Fatal error condition.
      MT_EMAIL = 3,	///< Condition which requires operator intervention.
      MT_PHONE = 4,	///< Condition which requires immediate operator intervention.
      MT_DEBUG = 5,	///< Debugging message intended for developers.
      MT_NOTE  = 6,	///< Notable condition which is not an error.
      MT_ORANGE,	///< Error condition not fatal to the job.
      MT_CERTMAIL,	///< Condition which requires operator intervention.

      MT_GREEN = MT_OK,		///< Alias for MT_OK
      MT_YELLOW = MT_WARN,	///< Alias for MT_WARN
      MT_RED = MT_ERROR,	///< Alias for MT_ERROR
      MT_MAIL = MT_EMAIL,	///< Alias for MT_EMAIL
      MT_PAGER = MT_PHONE,	///< Alias for MT_PHONE
      MT_BLUE = MT_DEBUG,	///< Alias for MT_DEBUG
      MT_PURPLE = MT_NOTE	///< Alias for MT_NOTE

    };

    //-------------------------------------------------------------------
    /// \brief Constructor
    ///
    /// \param[in] BaseName
    ///     The base name to be used for creation of the log file.
    ///
    /// \return
    ///     An instance of this object.
    //-------------------------------------------------------------------
    LogHTML( const std::string& BaseName );

    void Message( message_type MessageType, level_type Level,
		  const std::string& Caller, const std::string& JobInfo,
		  const std::string& Message );

    //-------------------------------------------------------------------
    /// \brief initialization that needs to happen when loaded into tcl.
    //-------------------------------------------------------------------
    static void TclInitialization( Tcl_Interp* Interp );

  protected:
    //-------------------------------------------------------------------
    /// \brief Rotate log files
    //-------------------------------------------------------------------
    virtual void rotate( );

  private:
    //-------------------------------------------------------------------
    /// \brief Write the HTML header into the log.
    //-------------------------------------------------------------------
    void html_header( );

    //-------------------------------------------------------------------
    /// \brief Write the HTML trailer into the log.
    //-------------------------------------------------------------------
    void html_trailer( );
  };
}

#endif /* GENERIC_API__LOG_HTML_HH */
 
