#ifndef FRAME_API__RESAMPLE_CMD_HH
#define FRAME_API__RESAMPLE_CMD_HH

#include "genericAPI/threaddecl.hh"

#include "framecmd.hh"

//!exc: SwigException   
Filters::ResampleBase* createResampleState(const int q,
					   const FrameCPP::FrAdcData* const adc);
//!exc: SwigException      
Filters::ResampleBase* createResampleState(const int q,
					   const FrameCPP::FrProcData* const proc);   
//!exc: SwigException   
void destructResampleState(Filters::ResampleBase* const r);

//!exc: SwigException      
REAL_8 resampleDelay( const FrameCPP::FrProcData* const proc,
		      const Filters::ResampleBase* const r );

//!exc: SwigException   
FrameCPP::FrProcData* resampleAdcData( const FrameCPP::FrAdcData* const adc,
                                     Filters::ResampleBase* const r );
CREATE_THREADED2_DECL( resampleAdcData,
		       FrameCPP::FrProcData*,
		       const FrameCPP::FrAdcData* const,
		       Filters::ResampleBase* const );

//!exc: SwigException   
FrameCPP::FrProcData* resampleProcData( const FrameCPP::FrProcData* const proc,
                                     Filters::ResampleBase* const r );
   
#endif /* FRAME_API__RESAMPLE_CMD_HH */
