#include <unistd.h>

#include "framecpp/Common/MD5Sum.hh"

#include "RDSStreamFileResample.hh"

using FrameCPP::Common::MD5Sum;
using FrameAPI::LogMD5Sum;

RDSStreamFileResample::
RDSStreamFileResample( const std::string& OutputDirectory,
		       const std::string& OutputType,
		       const rds_level_type RDSLevel,
		       const std::string& MD5SumOutputDirectory )
  : RDSStreamFileReduce( OutputDirectory,
		   OutputType,
		   RDSLevel,
		   MD5SumOutputDirectory )
{
}

RDSStreamFileResample::
~RDSStreamFileResample( )
{
}

#if 0
bool RDSStreamFileResample::
Next( const General::GPSTime& FrameStart,
      const REAL_8 Dt,
      INT_4U& FramesPerStream )
{
  std::cerr << "DEBUG:"
	    << " RDSStreamFileResample::Next:"
	    << " FrameStart: " << FrameStart
	    << " Dt: " << Dt
	    << " FramesPerStream: " << FramesPerStream
	    << std::endl
    ;
  bool	retval = false;

  if ( ( fileWriter( ).get( ) == (FileWriter*)NULL ) &&
       ( FrameStart >= m_user_start ) &&
       ( ( FrameStart + Dt ) <= m_user_stop ) )
  {
    openFrameFile( generateTmpOutputName( FrameStart.GetSeconds( ) ) );
    m_frame_file_start = FrameStart.GetSeconds( );
    m_frame_file_deltaT = 0;
    const INT_4U max( INT_4U( ( m_user_stop.GetSeconds( ) - FrameStart.GetSeconds( ) ) / Dt ) );
    if ( FramesPerStream > max )
    {
      FramesPerStream = max;
    }
    retval = true;
  }
  else if ( m_current_file_writer )
  {
    FramesPerStream = 1;
  }
  return retval;
}

void RDSStreamFileResample::
Write( frame_h_type Frame,
       compression_scheme_type CompressionScheme,
       compression_level_type CompressionLevel,
       chkSum_type CheckSum )
{
  std::cerr << "DEBUG:"
	    << " RDSStreamFileResample::Write:"
	    << " CompressionScheme: " << CompressionScheme
	    << " CompressionLevel: " << CompressionLevel
	    << std::endl
    ;
  if ( m_frame_file_deltaT == 0 )
  {
    m_frame_file_start = Frame->GetGTime( ).GetSeconds( );
  }
  m_frame_file_deltaT += Frame->GetDt( );
  file_writer_type	active =
    ( fileWriter( )
      ? fileWriter( )
      : m_current_file_writer );

  active->WriteFrame( Frame,
		      CompressionScheme,
		      CompressionLevel,
		      CheckSum );
}
#endif /* 0 */

void RDSStreamFileResample::
Close( bool Final )
{
  std::cerr << "DEBUG:"
	    << " RDSStreamFileResample::Close:"
	    << " Final: " << Final
	    << std::endl
    ;
  //---------------------------------------------------------------------
  // If this is the final closing, then shut things down
  //---------------------------------------------------------------------
  if ( Final )
  {
    close_frame_file( );
  }
  else
  {
    //------------------------------------------------------------------
    // Store and advance filename information
    //------------------------------------------------------------------
    std::cerr << "DEBUG:"
	      << " RDSStreamFileResample::Close:"
	      << " before m_current_filename: " << m_current_filename
	      << std::endl
      ;
    m_current_filename
      = RDSStreamFileReduce::currentFilename( );
    std::cerr << "DEBUG:"
	      << " RDSStreamFileResample::Close:"
	      << " before m_current_filename: " << m_current_filename
	      << std::endl
      ;
    //------------------------------------------------------------------
    // Setup for the next output file
    //------------------------------------------------------------------
    m_current_file_writer = fileWriter( );
    fileWriter( ).reset( );
  }
}

void RDSStreamFileResample::
close_frame_file( )
{
  std::cerr << "DEBUG:"
	    << " RDSStreamFileResample::close_frame_file:"
	    << std::endl
    ;
#if 0
   m_is_last_frame_of_file = m_options.FramesPerFile( );
#endif /* 0 */
   //--------------------------------------------------------------------
   // Write out the privious file
   //--------------------------------------------------------------------
   if ( m_current_file_writer )
   {
      //-----------------------------------------------------------------
      // Close output frame file, renaming it in accordance to
      //   user's request
      //-----------------------------------------------------------------
      m_current_file_writer->Close( );

      std::string	tmpfile( m_current_file_writer->GetFilename( ) );
      bool		calculating_md5_sum = true;
      MD5Sum	 	md5;

      try
      {
	 md5 = m_current_file_writer->GetMD5Sum( );
	 md5.Finalize( );
      }
      catch( ... )
      {
	 calculating_md5_sum = false;
      }

      // m_current_file_writer->SetMD5Sum( md5 );  // :TODO: Why is this needed?

      m_current_file_writer.reset( (FileWriter*)NULL );	// Free up resourses

      if ( m_current_filename.length( ) > 0 )
      {
	 if ( m_frame_file_deltaT <= 0 )
	 {
	    //-----------------------------------------------------------
	    // No frames were written to this file. Just remove it.
	    //-----------------------------------------------------------
	    unlink( tmpfile.c_str( ) );	// Remove the tempory file
	    return;
	 }
	 std::cerr << "DEBUG:"
		   << " RDSStreamFileResample::close_frame_file:"
		   << " before m_current_filename: " << m_current_filename
		   << std::endl
	   ;
	 m_current_filename
	   = RDSStreamFileReduce::currentFilename( );
	 std::cerr << "DEBUG:"
		   << " RDSStreamFileResample::close_frame_file:"
		   << " m_current_filename: " << m_current_filename
		   << std::endl
	   ;
	 m_frame_file_deltaT = 0;		// Reset
	 try
	 {
	    ensureNoSuchFile( m_current_filename );
	 }
	 catch( ... )
	 {
	    unlink( tmpfile.c_str( ) );	// Remove the tempory file
	    throw;
	 }
	 if ( rename( tmpfile.c_str( ), m_current_filename.c_str( ) ) != 0 )
	 {
	    //-----------------------------------------------------------
	    // Cannot rename the file. Must remove the temporary file
	    //   and inform the call about the error.
	    //-----------------------------------------------------------
	    unlink( tmpfile.c_str( ) );	// Remove the tempory file
	    std::ostringstream	oss;
	    
	    oss << "Unable to create: " << m_current_filename
		<< " src: " << tmpfile
		<< " perror: " << strerror( errno );
	    throw std::runtime_error( oss.str( ) );
	 }
	 if ( calculating_md5_sum )
	 {
	    LogMD5Sum( m_current_filename, md5,
		       m_md5sum_output_directory );
	 }
	 appendOutputFrameFilename( m_current_filename );
      } // if ( m_current_filename.length( ) > 0 )
   } // if ( m_current_file_writer )
}
