#ifndef FRAME_API__FRAME_HH
#define FRAME_API__FRAME_HH

#include <stdexcept>

#include "framecpp/OFrameStream.hh"

namespace FrameAPI
{
  class Channel;

  class Frame
    : public ::FrameCPP::OFrameFStream::frameh_type
  {
  public:
    //===================================================================

    class NoChannelFound
      : public std::runtime_error
    {
    public:
      NoChannelFound( const std::string& ChannelName );
    private:
      static std::string message( const std::string& ChannelName );
    };

    //===================================================================

    typedef ::FrameCPP::OFrameFStream::frameh_type frameh_type;
    typedef General::SharedPtr< Channel > channel_type;

    frameh_type operator=( frameh_type RHS );

    channel_type GetChannel( const std::string& ChannelName ) const;

    ::FrameCPP::OFrameFStream::frameh_type AsFrameH( );
  protected:
  private:
    typedef General::unordered_map< std::string,
				    channel_type > channel_container_type;

    mutable channel_container_type	m_channels;
  };

  inline ::FrameCPP::OFrameFStream::frameh_type Frame::AsFrameH( )
  {
    return *this;
  }
}


#endif /* FRAME_API__FRAME_HH */
