#ifndef FRAME_API__DEVICE_IO_CONFIGURATION_HH
#define FRAME_API__DEVICE_IO_CONFIGURATION_HH

#include <map>
#include <string>
#include <vector>

#include "general/types.hh"
#include "general/unordered_map.hh"
#include "general/mutexlock.hh"
#include "general/ReadWriteLock.hh"
#include "general/Singleton.hh"

#include "framecpp/Common/IOStream.hh"

#include "MountMgr.hh"

namespace FrameAPI
{
  //: Singleton to keep track of how to support io on a device
  class DeviceIOConfiguration
  {
    SINGLETON_TS_DECL( DeviceIOConfiguration );

  public:
    typedef INT_8U		dev_type;
    typedef FrameCPP::Common::FrameBufferInterface::buffer_size_type size_type;
    typedef bool		use_mmap_io_type;

    typedef struct {
      //: Size of cache to use. 0 for default, positive for use specified
      size_type		s_buffer_size;
      //: Boolean for determining to use mmap functionallity in the file buffer
      use_mmap_io_type	s_use_mmap_io;
    } Characteristics;

    typedef struct {
      std::string	s_name;
      Characteristics	s_characteristics;
    } Description;

    typedef std::vector< Description >	descriptions_type;

    //: Destructor
    ~DeviceIOConfiguration( );

    //: Fetch the options for the device associated with the file
    static void GetConfiguration( const char* Filename,
				  size_type& BufferSize,
				  bool& UseMemoryMappedIO );

    static void GetConfiguration( const char* Filename,
				  size_type& BufferSize,
				  bool& UseMemoryMappedIO,
				  std::string& FSType );

    //: Resets the cache to be empty
    static std::string Reset( const descriptions_type& Descriptions );

  private:
    typedef std::map< dev_type, Characteristics >
    cache_type;
    typedef General::unordered_map< std::string, Characteristics >
    fstype_cache_type;

    static General::ReadWriteLock::lock_type	m_cache_lock;
    static cache_type				m_cache;
    static fstype_cache_type			m_fstype_cache;
    static MountMgr				m_mount_mgr;
  }; // class - DeviceIOConfiguration

  inline void DeviceIOConfiguration::
  GetConfiguration( const char* Filename,
		    size_type& BufferSize,
		    bool& UseMemoryMappedIO )
  {
    std::string	fs_type = "__ignore__";

    GetConfiguration( Filename,
		      BufferSize,
		      UseMemoryMappedIO,
		      fs_type );
  }

} // namespace - FrameAPI

#endif /* FRAME_API__DEVICE_IO_CONFIGURATION_HH */
