#ifndef DISKCACHE_THREAD_COUNTER_HH
#define DISKCACHE_THREAD_COUNTER_HH

   
// General Header Files   
#include <general/ReadWriteLock.hh>
#include <general/types.hh>   
   
   
namespace diskCache
{
   //: Thread counter class.
   //
   // This class is designed to automize thread counter updates.
   //
   class ThreadCounter
   {
   public:      
   
      // Constructor
      ThreadCounter( INT_2S& counter, General::ReadWriteLock::lock_type& lock );
   
      // Destructor
      ~ThreadCounter();

   
   private:

      //: No default constructor
      ThreadCounter();
   
      //: No copy constructor
      ThreadCounter( const ThreadCounter& );   
   
      //: No operator=
      const ThreadCounter& operator=( const ThreadCounter& );         
   
   
      //: Reference to the counter to update.
      INT_2S& mCounter;
   
      //: Reference to the counter lock.   
      General::ReadWriteLock::lock_type& mCounterLock;
   };   
   
}
   
   
#endif   
