#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <unistd.h>

#include <cstdio>

#include "general/types.hh"

#include "FStream.hh"


namespace diskCache
{
  namespace Streams
  {
    OFStream::
    OFStream( const std::string& Filename )
      : m_filename( Filename )
    {
      m_filename_tmp = m_filename;

      m_filename_tmp += ".tmp";

      open( m_filename_tmp.c_str( ) );
    }

    OFStream::
    ~OFStream( )
    {
      close( );
      //-----------------------------------------------------------------
      // Rename the temporary file to the permanent filename
      //-----------------------------------------------------------------
      unlink( m_filename.c_str( ) );
      rename( m_filename_tmp.c_str( ),
	      m_filename.c_str( ) );
    }

  } // namespace - Streams
} // namespace - diskCache
