#ifndef DISKCACHE_API__IO_HH
#define DISKCACHE_API__IO_HH

#if !defined(SWIG)
#include "genericAPI/Logging.hh"

#include "diskcacheAPI/MountPointManagerSingleton.hh"
#include "diskcacheAPI/DirectoryManagerSingleton.hh"
#endif /* !defined(SWIG) */

namespace diskCache
{
  template< typename StreamT >
  inline StreamT& Read( StreamT& Stream )
  {
    static const char method_name[] = "diskCache::Read";

    {
      std::ostringstream    msg;
	
      msg << "Entry"
	;
      GenericAPI::queueLogEntry( msg.str( ),
				 GenericAPI::LogHTML::MT_DEBUG,
				 30,
				 method_name,
				 "CXX" );
    }
    diskCache::MountPointManagerSingleton::Read( Stream );
    diskCache::DirectoryManagerSingleton::Read( Stream );
    {
      std::ostringstream    msg;
	
      msg << "Exit"
	;
      GenericAPI::queueLogEntry( msg.str( ),
				 GenericAPI::LogHTML::MT_DEBUG,
				 30,
				 method_name,
				 "CXX" );
    }
    return Stream;
  }

  template< typename StreamT >
  inline StreamT& Write( StreamT& Stream )
  {
    static const char method_name[] = "diskCache::Write";

    {
      std::ostringstream    msg;
	
      msg << "Entry"
	;
      GenericAPI::queueLogEntry( msg.str( ),
				 GenericAPI::LogHTML::MT_DEBUG,
				 30,
				 method_name,
				 "CXX" );
    }
    diskCache::MountPointManagerSingleton::Write( Stream );
    diskCache::DirectoryManagerSingleton::Write( Stream );
    {
      std::ostringstream    msg;
	
      msg << "Exit"
	;
      GenericAPI::queueLogEntry( msg.str( ),
				 GenericAPI::LogHTML::MT_DEBUG,
				 30,
				 method_name,
				 "CXX" );
    }
    return Stream;
  }
} // namespace - diskCache

#endif /* DISKCACHE_API__IO_HH */
