// -*- mode: c++ basic-offset: 4; indent-tabs-mode: nil; -*-

#include <sstream>

#include "diskcacheAPI/Cache/QueryAnswer.hh"
#include "diskcacheAPI/Cache/QueryParams.hh"

namespace diskCache
{
  namespace Cache
  {
    QueryParams::MissingVariableError::
    MissingVariableError( const std::string& Variable )
      : std::runtime_error( format( Variable ) )
    {
    }

    std::string QueryParams::MissingVariableError::
    format( const std::string& Variable )
    {
      std::ostringstream	msg;

      msg << "Missing variable: " << Variable
	;
      return msg.str( );
    }

    void QueryParams::
    Translate( QueryAnswer& Answer,
	       const Registry& Indexes ) const
    {
      container_type::const_iterator
	index_name_pos( m_symbol_table.find( "index" ) );

      if ( index_name_pos == m_symbol_table.end( ) )
      {
	throw MissingVariableError( "index" );
      }
      //-----------------------------------------------------------------
      //
      //-----------------------------------------------------------------
    }
  } // namespace - Cache
} // namespace - diskCache
