#include "config.h"

#include <iterator>
#include <list>

#include "diskcacheAPI/Cache/Directory.hh"

#include "diskcacheAPI/Streams/Binary.hh"

#include "diskcacheAPI/Cache/SDGTx.hh"

#if 0
#define DEBUG_DIRECTORY 1
#endif /* 0 */

namespace diskCache
{
  namespace Cache
  {
    using Streams::IBinary;
    using Streams::OBinary;

    //-------------------------------------------------------------------
    /// Initialize the memory contents from the stream.
    /// This reads the contents for a single directory.
    //-------------------------------------------------------------------
    template< >
    IBinary& Directory::
    Read( IBinary& Stream )
    {
      const Streams::Interface::version_type
	version( Stream.Version( ) );
      typedef Streams::IBinary::size_type 	size_type;

      //-----------------------------------------------------------------
      /// \todo
      /// This can be optimized by reading the root followed by
      ///   reading the path relative to the root.
      /// The current implementation is waistful as the root portion
      /// is in both names.
      //-----------------------------------------------------------------
      typedef std::list< std::string > l_subdir_type;

      l_subdir_type   subdirs;
      l_subdir_type   subdirs_ignored;


#if DEBUG_DIRECTORY
      Stream >> m_name;
      std::cerr << "DEBUG: Directory::Read: fullname: " << m_name << std::endl;
      Stream >> m_root;
      std::cerr << "DEBUG: Directory::Read: m_root: " << m_root << std::endl;
      Stream >> subdirs;
      Stream >> subdirs_ignored;
      Stream >> m_last_time_modified;
      std::cerr << "DEBUG: Directory::Read: m_last_time_modified: " << m_last_time_modified << std::endl;
#else /* DEBUG_DIRECTORY */
      Stream >> m_name
	     >> m_root
	     >> subdirs
	     >> subdirs_ignored
	     >> m_last_time_modified
	;
#endif /* DEBUG_DIRECTORY */
      //-----------------------------------------------------------------
      // Create the children
      //-----------------------------------------------------------------
      m_subdirs_ignored.clear( );

      if ( subdirs_ignored.size( ) > 0 )
      {
	std::insert_iterator< ignored_type >
	  i( m_subdirs_ignored,
	     m_subdirs_ignored.begin( ) );
	m_subdirs_ignored.clear( );
	std::copy( subdirs_ignored.begin( ),
		   subdirs_ignored.end( ),
		   i );
      }
      //-----------------------------------------------------------------
      // Create the children
      //-----------------------------------------------------------------
      m_subdirs.clear( );
      if ( subdirs.size( ) > 0 )
      {

	std::insert_iterator< children_type >
	  i( m_subdirs,
	     m_subdirs.begin( ) );

	std::copy( subdirs.begin( ),
		   subdirs.end( ),
		   i );
      }
      //-----------------------------------------------------------------
      // Read the indexing nodes
      //-----------------------------------------------------------------
      size_type	indexes_count( 1 );
      if ( version >= Streams::Interface::VERSION_GENERIC_INDEXES )
      {
	Stream >> indexes_count;
      }
      for ( size_type
	      indexes_cur = 0;
	    indexes_cur != indexes_count;
	    ++indexes_cur )
      {
	std::string	index;

	if ( version >= Streams::Interface::VERSION_GENERIC_INDEXES )
	{
	  Stream >> index;
	}
	else
	{
	  index = SDGTx::AsciiId;
	}
	//----------------------------------------------------------------
	// Obtain the numeric value of the index and read the object
	// from the stream
	//----------------------------------------------------------------
	const RegistrySingleton::id_type
	  id( RegistrySingleton::Id( index ) );

	IBinary::read_func	func( IBinary::Reader( id ) );

	IBinary::read_return_type	v( (*func)( Stream ) );

	if ( v )
	{
	  //-------------------------------------------------------------
	  // With an object ligitimately read, record it for future
	  // use.
	  //-------------------------------------------------------------
	  m_indexes[ id ] = v;
	}
      }
      return Stream;
    }

    //-------------------------------------------------------------------
    // Write the memory contents out to the stream.
    //-------------------------------------------------------------------
    template< >
    OBinary& Directory::
    Write( OBinary& Stream ) const
    {
      const Streams::Interface::version_type
	version( Stream.Version( ) );
      typedef Streams::OBinary::size_type 	size_type;

      //-----------------------------------------------------------------
      /// \todo
      /// This can be optimized by writing the root followed by
      ///   Writing the path relative to the root.
      /// The current implementation is waistful as the root portion
      /// is in both names.
      //-----------------------------------------------------------------

#if DEBUG_DIRECTORY
      Stream << Fullname( );
      std::cerr << "DEBUG: Directory::Write: fullname: " << Fullname( ) << std::endl;
      Stream << Root( );
      std::cerr << "DEBUG: Directory::Write: Root( ) " << Root( ) << std::endl;
      Stream << m_subdirs;
      Stream << m_subdirs_ignored;
      Stream << m_last_time_modified;
      std::cerr << "DEBUG: Directory::Write: m_last_time_modified: " << m_last_time_modified << std::endl;
#else /* DEBUG_DIRECTORY */
      Stream << Fullname( )
	     << Root( )
	     << m_subdirs
	     << m_subdirs_ignored
	     << m_last_time_modified
	;
#endif /* DEBUG_DIRECTORY */
      //-----------------------------------------------------------------
      // Writing of the search specific data
      //-----------------------------------------------------------------
      index_container_type::const_iterator
	indexes_cur = m_indexes.begin( ),
	indexes_last = m_indexes.end( );

      if ( version >= Streams::Interface::VERSION_GENERIC_INDEXES )
      {
        //---------------------------------------------------------------
        /// \todo
        /// Loop over all of the associated indexes and have them
        /// dump their information to the Stream
        //---------------------------------------------------------------
	size_type indexes_count( m_indexes.size( ) );

	Stream << indexes_count;
      }
      else
      {
	const RegistrySingleton::id_type
	  id( RegistrySingleton::Id( SDGTx::AsciiId ) );

	indexes_cur = m_indexes.find( id );
	if (indexes_cur != indexes_last )
	{
	  indexes_last = indexes_cur;
	  ++indexes_last;
	}
	else
	{
	  OBinary::write_func	func( OBinary::Writer( id ) );

	  SDGTx::DirectoryInfo		data;

	  (*func)( Stream, data );
	}
      }

      while ( indexes_cur != indexes_last )
      {
	try
	{
	  RegistrySingleton::info_type
	    reg_info( RegistrySingleton::GetInfo( indexes_cur->first ) );

	  OBinary::write_func	func( OBinary::Writer( indexes_cur->first ) );

	  if ( version >= Streams::Interface::VERSION_GENERIC_INDEXES )
	  {
	    //-----------------------------------------------------------
	    // Write the label
	    //-----------------------------------------------------------
	    Stream << reg_info->m_key_name;
	  }
	  //-------------------------------------------------------------
	  // Write the output
	  //-------------------------------------------------------------
	  General::SharedPtr< Streams::Streamable >
	    data( indexes_cur->second );
	  (*func)( Stream, *data );
	}
	catch( ... )
	{
	  //-------------------------------------------------------------
	  // Should only have a range error, either on the reg_info
	  // or for func.
	  // Either way, cannot write the information to the stream.
	  // Quietly absorb the condition and continue with the
	  // next entry.
	  //-------------------------------------------------------------
	}
	//---------------------------------------------------------------
	// Advance 
	//---------------------------------------------------------------
	++indexes_cur;
      }
      return Stream;
    } // method template<> Write( )

  } // namespace - Cache

} // namespace - diskCache

