/* -*- mode: c++; c-basic-offset: 2; -*- */

#include "general/config.h"

#include <time.h>

#include <iostream>

#include "general/TaskTimer.hh"

namespace General
{
  Timer::
  Timer( int Seconds, int CancelSignal )
    : Task( CancelSignal ),
      m_timeout( Seconds ),
      m_err( false )
  {
    MutexLock	l( m_key );
  }

  bool Timer::
  Error( ) const
  {
    MutexLock	l( m_key );

    return m_err;
  }

  void Timer::
  operator()( )
  {
    struct timespec wakeup;

    {
      MutexLock	l( m_key );

      wakeup.tv_sec = m_timeout;
      wakeup.tv_nsec = 0;
    }

    int err = ( nanosleep( &wakeup, NULL ) != 0 );
    {
      MutexLock	l( m_key );

      m_err = err;
    }
  }
}
