#include "general/config.h"

#include <string.h>
#include <errno.h>

#include <iostream>
#include <sstream>

#include "general/autoarray.hh"
#include "general/System.hh"

#if STRERROR_R_CHAR_P
typedef char* strerror_r_retval;
#define STRERROR_R_OK( a ) ( a != (strerror_r_retval)NULL )
#else /* STRERROR_R_CHAR_P */
typedef int strerror_r_retval;
#define STRERROR_R_OK( a ) ( a == 0 )
#endif /* STRERROR_R_CHAR_P */

namespace General
{
  namespace System
  {
    const std::string
    ErrnoMessage( )
    {
      static const int BUFFER_SIZE = 1024;

      General::AutoArray< char > buffer( new char[ BUFFER_SIZE ] );
      strerror_r_retval error_string( strerror_r( errno, buffer.get( ),
						  BUFFER_SIZE - 1 ) );

      if ( ! STRERROR_R_OK( error_string ) )
      {
	std::cerr << "WARN: General::System::ErrnoMessage( ):"
		  << " strerror_r returned: "
	  ;
	switch( errno )
	{
	case EINVAL:
	  std::cerr << "EINVAL";
	  break;
	case ERANGE:
	  std::cerr << "ERANGE";
	  break;
	default:
	  std::cerr << errno;
	  break;
	}
	std::cerr << std::endl;
	buffer[ 0 ] = '\0';
      }

      std::ostringstream msg;

      msg << " errno=" << errno << " ("
#if STRERROR_R_CHAR_P
	  << error_string
#else /* STRERROR_R_CHAR_P */
	  << buffer.get( )
#endif /* STRERROR_R_CHAR_P */
	  << ")";
   
      return msg.str();
    }
  }
}
