/* -*- mode: c++; c-basic-offset: 2; -*- */
#ifndef GENERAL__SINGLETON_T_HH
#define GENERAL__SINGLETON_T_HH

namespace General
{
  /// \brief  Class to ensure proper Assignments
  class SingletonClient
  {
  public:
    SingletonClient( )
    {
    }
  private:
    /// \brief  Hide copy constructor
    SingletonClient( const SingletonClient& Source );
    /// \brief  Hide assignment operator
    SingletonClient operator=( const SingletonClient& Source );
  }; // class SingletonClient

  /// \brief  Template to ensure a single instance of a class.
  template< class T >
  class Singleton
  {
  public:
    /// \brief  Obtain reference to the only instance of the class.
    static T& Instance( )
    {
      static T	instance;

      return instance;
    }
    /// \brief  Obtain pointer to the only instance of the class.
    static T* PInstance( )
    {
      T& instance = Instance( );
      return &instance;
    }
  protected:
  private:
    /// \brief  Hide default constructor
    Singleton( );
    /// \brief  Hide default destructor
    ~Singleton( );
    /// \brief  Hide copy constructor
    const Singleton& operator=( const Singleton& Source );
  }; // class Singleton

} // namespace - General

#endif	/* GENERAL_SINGLETON_T_HH */
