#include "general/config.h"

#include "general/AtExit.hh"
#include "general/IOLock.hh"

pthread_mutex_t	General::IOLock::m_key_ostream = PTHREAD_MUTEX_INITIALIZER;

General::IOLock::keys_ostream_type	General::IOLock::m_keys_ostream;

pthread_mutex_t* General::IOLock::
GetKey( const std::ostream& Stream )
{
  MutexLock			lock( m_key_ostream );
  pthread_mutex_t*		key;
  keys_ostream_type::iterator	cur;
  keys_ostream_type::iterator	last;
  
  for( cur = m_keys_ostream.begin( ),
	 last = m_keys_ostream.end( );
       cur != last;
       ++cur )
  {
    if ( (*cur)->key == (&Stream) )
    {
      break;
    }
  }
  if ( cur == last )
  {
    m_keys_ostream.push_back( new lock_set );
    m_keys_ostream.back( )->key = &Stream;
    key = &( m_keys_ostream.back( )->lock );
    pthread_mutex_init( key, NULL );
  }
  else
  {
    key = &( (*cur)->lock );
  }
  return key;
}
