#ifndef GENERAL__FILE_TYPE_HH
#define GENERAL__FILE_TYPE_HH

#include <string>

namespace General
{
  class FileType
  {
  public:
    enum types {
      FT_UNKNOWN_BINARY,
      FT_UNKNOWN_TEXT,
      FT_EPS,
      FT_FRAME,
      FT_GIF,
      FT_GZIP,
      FT_HTML,
      FT_HTML_404,
      FT_HTML_ERROR,
      FT_ILWD,
      FT_ILWD_FRAME,
      FT_JPEG,
      FT_PDF,
      FT_PGP,
      FT_PNG,
      FT_PS,
      FT_SCRIPT,
      FT_TIFF,
      FT_XML,
      FT_XML_DOC
    };

    FileType( const std::string& Filename );
    const std::string& GetFileType( ) const;
  private:
    std::string		m_type_desc;
  };

  inline const std::string& FileType::
  GetFileType( ) const
  {
    return m_type_desc;
  }
}

#endif /* GENERAL__FILE_TYPE_HH */
