#if HAVE_CONFIG_H
#include "framecpp/config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <fstream>

#include "framecpp/FrameH.hh"
#include "framecpp/FrAdcData.hh"
#include "framecpp/FrRawData.hh"
#include "framecpp/IFrameStream.hh"

int
main(int argc, char *argv[])
{
  std::ifstream in(argv[1]);
  FrameCPP::IFrameStream fs(in);
  FrameCPP::FrRawData::firstAdc_type adc;
  adc.erase( adc.begin(), adc.end() );

  FrameCPP::FrAdcData*
    adcptr( fs.ReadFrAdcData(0, "L1:LSC-DARM_GAIN") );

  if ( adcptr == 0 )
  {
    exit(1);
  }

#if 0
  // Program hangs if I do this instead...
  adc.append ( adcptr, false, false );
  adc.erase( adc.begin(), adc.end() );
#else
  // Program core dumps if this
  adc.append ( adcptr, true, true );
  adc.erase( adc.begin(), adc.end() );
#endif
}
