#include "framecpp/config.h"

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrSimData.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"

#include "framecpp/Version8/PTR_STRUCT.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

//=======================================================================
// Static
//=======================================================================
static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_SIM_DATA;

//=======================================================================
// FrSimData
//=======================================================================
FrSimData::
FrSimData( )
  : object_type( s_object_id, StructDescription( ) )
{
}

FrSimData::
FrSimData( const FrSimData& Source )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimDataStorage( Source ),
    FrSimDataRefs( Source ),
    Common::TOCInfo( Source )
{
}

FrSimData::
FrSimData( const std::string& Name,
	   const std::string& Comment,
	   const REAL_8 SampleRate, 
	   const REAL_8 FShift,
	   const REAL_4 Phase,
	   const REAL_8 TimeOffset )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimDataStorage( Name,
		      Comment,
		      SampleRate,
		      FShift,
		      Phase,
		      TimeOffset )
{
}

FrSimData::
FrSimData( Previous::FrSimData& Source,
	   Common::IStream* Stream )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimDataStorage( Source )
{
  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( RefData( ), Source.RefData( ),
			Previous::FrSimData::MAX_REF );
    Stream->ReplaceRef( RefInput( ), Source.RefInput( ),
			Previous::FrSimData::MAX_REF );
    Stream->ReplaceRef( RefTable( ), Source.RefTable( ),
			Previous::FrSimData::MAX_REF );
  }
}

FrSimData::
FrSimData( Common::IStream& Stream )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data( Stream );
  m_refs( Stream );
  Stream.Next( this );
}

const char* FrSimData::
ObjectStructName( ) const
{
  return StructName( );
}

const Description* FrSimData::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrSimData::StructName( ), s_object_id,
	       "Simulated Data Structure" ) );

    ret( FrSE( "name", "STRING" ) );
    ret( FrSE( "comment", "STRING" ) );
    ret( FrSE( "sampleRate", "REAL_8" ) );
    ret( FrSE( "timeOffset", "REAL_8" ) );
    ret( FrSE( "fShift", "REAL_8" ) );
    ret( FrSE( "phase", "REAL_4" ) );

    ret( FrSE( "data",	PTR_STRUCT::Desc( FrVect::StructName() ) ) );
    ret( FrSE( "input", PTR_STRUCT::Desc( FrVect::StructName() ) ) );
    ret( FrSE( "table", PTR_STRUCT::Desc( FrTable::StructName() ) ) );

    ret( FrSE( "next", PTR_STRUCT::Desc( FrSimData::StructName() ) ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

const std::string& FrSimData::
GetNameSlow() const
{ 
  return GetName( );
}

FrSimData& FrSimData::
Merge( const FrSimData& RHS )
{
  //:TODO: Need to implement Merge routine
  std::string msg( "Merge currently not implemented for " );
  msg += StructName( );

  throw std::domain_error( msg );
  return *this;
}


void FrSimData::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
{
  using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
  va_list	vl;
  va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

  while ( InfoClass != TOCInfo::IC_EOQ )
  {
    int data_type = va_arg( vl, int );
    switch( data_type )
    {
    case TOCInfo::DT_STRING_2:
      {
	STRING* data = va_arg( vl, STRING* );
	switch( InfoClass )
	{
	case TOCInfo::IC_NAME:
	  *data = GetName( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    default:
      // Stop processing
      goto cleanup;
    }
    InfoClass = va_arg( vl, int );
  }
 cleanup:
#if WORKING_VIRTUAL_TOCQUERY
  va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    ;
}

bool FrSimData::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return ( *this == RHS );
}

FrSimData::demote_ret_type FrSimData::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Copy non-reference information
    //-------------------------------------------------------------------
    // Do actual down conversion
    General::SharedPtr< Previous::FrSimData >
      retval( new Previous::FrSimData( GetName( ),
				       GetComment( ),
				       GetSampleRate( ),
				       GetFShift( ),
				       GetPhase( ),
				       GetTimeOffset( )
				       ) )
      ;
    if ( Stream )
    {
      //-----------------------------------------------------------------
      // Modify references
      //-----------------------------------------------------------------
      Stream->ReplaceRef( retval->RefData( ), RefData( ), MAX_REF );
      Stream->ReplaceRef( retval->RefInput( ), RefInput( ), MAX_REF );
      Stream->ReplaceRef( retval->RefTable( ), RefTable( ), MAX_REF );
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }
  throw
    Unimplemented( "Object* FrSimData::demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrSimData::promote_ret_type FrSimData::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return Promote( Target, Obj, Stream );
}

FrameCPP::cmn_streamsize_type FrSimData::
pBytes( const Common::StreamBase& Stream ) const
{
  return
    m_data.Bytes( Stream )
    + m_refs.Bytes( Stream )
    + Stream.PtrStructBytes( )	// next
    ;
    
}

FrSimData* FrSimData::
pCreate( Common::IStream& Stream ) const
{
  return new FrSimData( Stream );
}

void FrSimData::
pWrite( Common::OStream& Stream ) const
{
  m_data( Stream );
  m_refs( Stream );
  WriteNext( Stream );
}
