#ifndef FrameCPP__VERSION_8__FrSE_HH
#define FrameCPP__VERSION_8__FrSE_HH

#include "framecpp/Common/FrameSpec.hh"

#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //-------------------------------------------------------------------
    /// \brief Contains field information of a dictionary structure.
    ///
    /// This class gives information describing a single field of the
    /// class structure being described.
    /// In a dicitionary structure, there may be multiple occurances
    /// of FrSE.
    /// The order of the FrSE corresponds to the order of the fields
    /// as written to the stream.
    ///
    /// \see FrSH
    //-------------------------------------------------------------------
    class FrSE
      : public ObjectWithChecksum< Common::FrameSpec::Object >
    {
    public:

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      FrSE( );

      //-----------------------------------------------------------------
      /// \brief constructor
      ///
      /// \param[in] Name
      ///     Name of an element of the structure being described by
      ///     this dictionary structure.
      /// \param[in] ClassId
      ///     The data type of the element being described by this
      ///     dictionary structure.
      /// \param[in] Comment
      ///     Description of the element being described by this
      ///     dictionary strucutre.
      //-----------------------------------------------------------------
      FrSE( const std::string& Name,
	    const std::string& ClassId,
	    const std::string& Comment = "" );

      //-----------------------------------------------------------------
      /// \brief Desctructor
      //-----------------------------------------------------------------
      virtual ~FrSE( );

      //-----------------------------------------------------------------
      /// \brief Dictionary class name
      ///
      /// \return
      ///     The dictionary class name for this structure.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Return class of object
      //-----------------------------------------------------------------
      std::string GetClass( ) const;

      //-----------------------------------------------------------------
      /// \brief Return comment of object
      //-----------------------------------------------------------------
      std::string GetComment( ) const;

      //-----------------------------------------------------------------
      /// \brief Return name of object
      //-----------------------------------------------------------------
      std::string GetName( ) const;

      //-----------------------------------------------------------------
      /// \brief Create a new instance of the object based on self.
      //-----------------------------------------------------------------
      virtual FrSE* Clone( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the dictionary name of the structure.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief comparison operator
      //-----------------------------------------------------------------
      bool operator==( const FrSE& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief comparison operator
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Down grade an object
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Upgrade an object
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      // \brief Return the number of bytes needed to write this object
      //-----------------------------------------------------------------
      virtual INT_8U pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Create a new instance of the object based on the input stream
      //-----------------------------------------------------------------
      virtual FrSE* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      // \brief Write core components to the stream
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

    private:
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      //-----------------------------------------------------------------
      /// \brief Dictionary class id for this structure.
      //-----------------------------------------------------------------
      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_SE;
      
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      struct image_t
      {
	//---------------------------------------------------------------
	/// Name of an element of the structure being described.
	/// All element names within the structure must be unique.
	//---------------------------------------------------------------
	STRING	name;
	//---------------------------------------------------------------
	/// The string representation of data type of the element.
	//---------------------------------------------------------------
	STRING	classId;
	//---------------------------------------------------------------
	/// Description of the element.
	//---------------------------------------------------------------
	STRING	comment;
      } m_data;

      //-----------------------------------------------------------------
      /// \brief Constructor (Stream)
      ///
      /// Construct a new FrSE by reading the input stream.
      ///
      /// \param[in] Stream
      ///     The stream from which to construct the new FrSE structure.
      //-----------------------------------------------------------------
      FrSE( Common::IStream& Stream );

    }; // class - FrSE

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    inline const char* FrSE::
    StructName( )
    {
      static const char* class_name( "FrSE" );
      return class_name;
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    inline std::string FrSE::
    GetClass( ) const
    {
      return m_data.classId;
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    inline std::string FrSE::
    GetComment( ) const
    {
      return m_data.comment;
    }

  } // namespace - Version_8
} // namespace - FrameCPP
#endif /* FrameCPP__VERSION_8__FrSE_HH */
