#include "framecpp/config.h"

#define ACCESS_FRAME_H_PRIVATE_PARTS 1

#include "general/types.hh"

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/Verify.hh"

#include "framecpp/Version7/FrameH.hh"
#include "framecpp/Version7/FrSE.hh"
#include "framecpp/Version7/FrSH.hh"
#include "framecpp/Version7/FrEndOfFrame.hh"
#include "framecpp/Version7/PTR_STRUCT.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;

#define TRACE_MEMORY 0
#if TRACE_MEMORY
#define MEM_ALLOCATE() std::cerr << "MEMORY: Allocate: " << FrameH::getStaticName() << " " << (void*)this << std::endl;
#define MEM_DELETE() std::cerr << "MEMORY: Delete: " << FrameH::getStaticName() << " " << (void*)this << std::endl;
#else
#define MEM_ALLOCATE()
#define MEM_DELETE()
#endif

#define	LM_DEBUG 0

#if LM_DEBUG
#define	AT() std::cerr << __FILE__ << " " << __LINE__ << std::endl;
#else
#define	AT()
#endif

namespace FrameCPP
{
  namespace Version_7
  {
    //=======================================================================
    //
    //=======================================================================
    FrameH::
    FrameH( )
      : Common::FrameH( StructDescription( ) )
    {
      MEM_ALLOCATE();
    }

    FrameH::
    FrameH( const FrameH& frame )
      : Common::FrameH( StructDescription( ) ),
	FrameHNPS( frame ),
	FrameHPS( frame )
    {
    }

    FrameH::
    FrameH( const std::string& name,
	    INT_4S run,
	    INT_4U frame,
	    const GPSTime& time,
	    INT_2U uLeapS,
	    const REAL_8 dt,
	    INT_4U dqual )
      : Common::FrameH( StructDescription( ) ),
	FrameHNPS( name, run, frame, time, uLeapS, dt, dqual )
    {
      MEM_ALLOCATE();
    }

    FrameH::
    FrameH( const FrameHNPS& Source )
      : Common::FrameH( StructDescription( ) ),
	FrameHNPS( Source )
    {
    }

    FrameH::
    FrameH( istream_type& Stream )
      : Common::FrameH( StructDescription( ) )
    {
      m_data( Stream );
      m_refs( Stream );
    }

    FrameH::
    ~FrameH( )
    {
      MEM_DELETE();
    }


    FrameCPP::cmn_streamsize_type FrameH::
    Bytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.Bytes( )
	+ m_refs.Bytes( )
	;
    }

    FrameH* FrameH::
    Clone( ) const
    {
      return new FrameH( *this );
    }

    FrameH* FrameH::
    Create( istream_type& Stream ) const
    {
      return new FrameH( Stream );
    }

    const char* FrameH::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrameH::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( FrameH::StructName( ),
		   FrameCPP::Common::FrameH::s_object_id,
		   "Frame Header Structure" ) );
	dataDescription< FrSE >( ret );
	refDescription< FrSE >( ret );

      }

      return &ret;
    }

    void FrameH::
    Write( ostream_type& Stream ) const
    {
#if WORKING
      //---------------------------------------------------------------------
      // Check to see if per frame checksums are to be calculated
      //---------------------------------------------------------------------
      if ( Stream.IsCalculatingChecksumFrame( ) )
      {
	//-------------------------------------------------------------------
	// Yes ...
	// 1) Reset the buffer
	// 2) Add in the FrBase info
	//-------------------------------------------------------------------
	Stream.SetChecksumMethodFrame( );

	INT_8U	length = GetLength( );
	INT_2U	class_id = GetClassId( );
	INT_4U	instance = GetInstance( );

	Stream.calcChecksumFrame( &length, sizeof( length ) );
	Stream.calcChecksumFrame( &class_id, sizeof( class_id ) );
	Stream.calcChecksumFrame( &instance, sizeof( instance ) );
      }
#endif /* WORKING */

      m_data( Stream );
      m_refs( Stream );
  
  
      object_type	eof( new FrEndOfFrame( GetRun( ), GetFrame( ) ) );

      Stream.PushSingle( eof );
    }

    void FrameH::
    VerifyObject( Common::Verify& Verifier,
		  Common::IFrameStream& Stream ) const
    {
      if ( Verifier.ValidateMetadata( ) &&
	   ( GetGTime( ).GetLeapSeconds( ) != GetULeapS( ) ) )
      {
	std::ostringstream	msg;

	msg << "Bad ULeapS value ( for gpstime: "
	    << GetGTime( )
	    << " expected: "
	    << GetGTime( ).GetLeapSeconds( )
	    << " read: " << GetULeapS( )
	    << " )"
	  ;
	throw Common::VerifyException( Common::VerifyException::METADATA_INVALID,
				       msg.str( ) );
      }
    }
		  
    bool FrameH::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return compare( *this, Obj );
    }

    FrameH::demote_ret_type FrameH::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      if ( Target >= DATA_FORMAT_VERSION )
      {
	return Obj;
      }
      try
      {
	//-------------------------------------------------------------------
	// Copy non-reference information
	//-------------------------------------------------------------------
	// Do actual down conversion
	General::SharedPtr< Previous::FrameH >
	  retval( new Previous::FrameH( GetName( ),
					GetRun( ),
					GetFrame( ),
					GetGTime( ),
					GetULeapS( ),
					GetDt( ),
					GetDataQuality( )
					) )
	  ;
	if ( Stream )
	{
	  //-----------------------------------------------------------------
	  // Modify references
	  //-----------------------------------------------------------------
#if WORKING
	  const void* rd( &(m_refs.rawData) );
#endif

	  Stream->ReplaceRef( retval->RefType( ), RefType( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefUser( ), RefUser( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefDetectSim( ), RefDetectSim( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefDetectProc( ), RefDetectProc( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefHistory( ), RefHistory( ), MAX_REF );
	  Stream->ReplacePtr( retval->AddressOfRawData( ),
			      AddressOfRawData( ),
			      MAX_REF );
	  Stream->ReplaceRef( retval->RefProcData( ), RefProcData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSimData( ), RefSimData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefEvent( ), RefEvent( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSimEvent( ), RefSimEvent( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSummaryData( ), RefSummaryData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefAuxData( ), RefAuxData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefAuxTable( ), RefAuxTable( ), MAX_REF );

	}
	//-------------------------------------------------------------------
	// Return demoted object
	//-------------------------------------------------------------------
	return retval;
      }
      catch( ... )
      {
      }
      throw
	Unimplemented( "Object* FrameH::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrameH::promote_ret_type FrameH::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      return Promote( Target, Obj, Stream );
    }

    void FrameH::
    readSubset( istream_type& Stream, INT_4U ElementMask )
    {
      m_refs.readSubset( Stream, ElementMask );
    }

    void FrameH::
    assign( assign_stream_type& Stream )
    {
      FrameHNPS::assign( Stream );
    }
  } // namespace - Version_7
} // namespace - FrameCPP
