#ifndef FrameCPP_VERSION_6_FrEndOfFile_HH
#define FrameCPP_VERSION_6_FrEndOfFile_HH

#include "general/types.hh"

#include "framecpp/Version6/FrameSpec.hh"

#include "framecpp/Common/FrEndOfFile.hh"

namespace FrameCPP
{
  namespace Version_6
  {
    class FrEndOfFile
      : public Common::FrEndOfFile
    {
    public:
      typedef INT_4U nFrames_type;
      typedef INT_8U nBytes_type;
      typedef INT_4U chkType_type;
      typedef INT_4U chkSum_type;
      typedef INT_8U seekTOC_type;

      FrEndOfFile( );
      virtual ~FrEndOfFile( );

      static const char* StructName( );

      static const Common::Description* StructDescription( );

      virtual Common::FrameSpec::size_type
      Bytes( const Common::StreamBase& Stream ) const;

      virtual FrEndOfFile* Clone( ) const;

      virtual FrEndOfFile* Create( istream_type& Stream ) const;

      virtual nBytes_cmn_type NBytes( ) const;

      virtual const char* ObjectStructName( ) const;

      virtual void Write( ostream_type& Stream ) const;

      /// \brief comparison operator
      bool operator==( const FrEndOfFile& RHS ) const;

      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_END_OF_FILE;

      nBytes_type GetNBytes( ) const;

      nFrames_type GetNFrames( ) const;

      chkSum_type GetChkSum( ) const;

      seekTOC_type GetSeekTOC( ) const;

      chkType_type GetChkType( ) const;

      virtual FrEndOfFile::seekTOC_cmn_type SeekTOC( ) const;

      virtual void VerifyObject( Common::Verify& Verifier,
				 Common::IFrameStream& Stream ) const;

    protected:
      nFrames_type	m_nFrames;
      nBytes_type	m_nBytes;
      chkType_type	m_chkType;
      chkSum_type	m_chkSum;
      seekTOC_type	m_seekTOC;

      //-----------------------------------------------------------------
      /// \brief Assign the contents of the instance
      ///
      /// \param[in] Stream
      ///     An input stream from which to read information for
      ///     the instance.
      ///
      //-----------------------------------------------------------------
      virtual void assign( assign_stream_type& Stream );

      /// \brief Down grade an object
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

    private:
      using Common::FrameSpec::Object::Create;

      FrEndOfFile( istream_type& Source );

      //-----------------------------------------------------------------
      /// \brief Filter a sequence of bytes
      ///
      /// \param[in] Stream
      ///     The input stream for Buffer.
      /// \param[in,out] Filt
      ///     The filter action to apply to Buffer.
      /// \param[in] Buffer
      ///     The sequence of bytes to be filter.
      /// \param[in] Size
      ///     The number of bytes in Buffer.
      ///
      /// \return
      ///     The type of checksum that was performed.
      //-----------------------------------------------------------------
      chkSum_cmn_type Filter( const istream_type& Stream,
			      Common::CheckSum& Filt,
			      chkType_cmn_type& Type,
			      void* Buffer,
			      INT_8U Size ) const;
    }; // class - FrEndOfFile

    inline const char* FrEndOfFile::
    StructName( )
    {
      static const CHAR* class_name( "FrEndOfFile" );
      return class_name;
    }

    inline FrEndOfFile::nBytes_type FrEndOfFile::
    GetNBytes( ) const
    {
      return m_nBytes;
    }

    inline FrEndOfFile::nFrames_type FrEndOfFile::
    GetNFrames( ) const
    {
      return m_nFrames;
    }

    inline FrEndOfFile::chkSum_type FrEndOfFile::
    GetChkSum( ) const
    {
      return m_chkSum;
    }

    inline FrEndOfFile::chkType_type FrEndOfFile::
    GetChkType( ) const
    {
      return m_chkType;
    }

    inline FrEndOfFile::seekTOC_type FrEndOfFile::
    GetSeekTOC( ) const
    {
      return m_seekTOC;
    }


    inline Common::FrEndOfFile::seekTOC_cmn_type FrEndOfFile::
    SeekTOC( ) const
    {
      return GetSeekTOC( );
    }
  } // namespace - Version_6
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_6_FrEndOfFile_HH */
