#include "framecpp/config.h"

#include "framecpp/Version6/Dimension.hh"

namespace FrameCPP
{
  namespace Version_6
  {
    //------------------------------------------------------------------
    // Constructors
    //------------------------------------------------------------------


    //------------------------------------------------------------------
    //
    //: Default Constructor.
    //
    // This creates a dimension object with the following values:
    //
    //   Dimension Length (Nx) - 1
    //   Scale Factor (Dx) - 1.0
    //   Units (UnitX) - ""
    //
    //!exc: None.   
    //   
    Dimension::Dimension()
      : mNx( 1 ),
	mDx( 1.0 ),
	mUnitX( "" ),
	mStartX( .0 )
    {
    }


    //------------------------------------------------------------------
    //
    //: Copy constructor.
    //
    //!param: const Dimension& dim - The Dimension to copy from.
    //
    //!exc: std::bad_alloc - Memory allocation failed.
    //
    Dimension::
    Dimension( const Dimension& dim )
      : mNx( dim.mNx ),
	mDx( dim.mDx ),
	mUnitX( dim.mUnitX ), 
	mStartX( dim.mStartX )
    {
    }
    

    //------------------------------------------------------------------
    /// \brief Constructor
    ///
    /// This creates a Dimension object with the specified attributes.
    ///
    /// \param[in] nx
    ///     The dimension length.
    /// \param[in] dx
    ///     The Scale Factor.
    /// \param[in] unitX
    ///     The units (unit per step size).
    /// \param[in] startx
    ///     The origin of the data set.
    ///
    /// \exception std::bad_alloc
    ///     Memory allocation failed.
    //------------------------------------------------------------------
    Dimension::
    Dimension(INT_8U nx,
	      REAL_8 dx,
	      const std::string& unitX,
	      REAL_8 startx )
      : mNx( nx ),
	mDx( dx ),
	mUnitX( unitX ),
	mStartX( startx )
    {
    }
  } // namespace - Version_6
} // namespace - FrameCPP
