#ifndef FrameCPP__VERSION_4__Specs_HH
#define FrameCPP__VERSION_4__Specs_HH

#include "general/types.hh"

#include "framecpp/Common/FrameSpec.hh"

#if defined(__cplusplus) && ! defined(SWIG)
namespace FrameCPP
{
  namespace Version_3 {}

  //---------------------------------------------------------------------
  /// \brief Implementation of the version 4 specification
  ///
  /// This namespace includes classes and functions needed to implement
  /// the version 4 frame specification as described by LIGO-T970130-D-E
  /// dated December 8, 2000.
  //---------------------------------------------------------------------
  namespace Version_4
  {
    namespace Previous = Version_3;

    typedef REAL_4 dt_type;
    typedef INT_8U position_type;

    const CHAR_U DATA_FORMAT_VERSION( 4 );
    const CHAR_U LIBRARY_MINOR_VERSION( 10 );

  } // namespace - Version_4
} // namespace - FrameCPP
#endif /* defined(__cplusplus) && ! defined(SWIG) */
#endif /* FrameCPP__VERSION_4__Specs_HH */
