#include "framecpp/config.h"

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/IOStream.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrTable.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/PTR_STRUCT.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;

namespace FrameCPP
{
  namespace Version_4
  {
    //=======================================================================
    //=======================================================================

    FrTableNPS::data_type::
    data_type( const data_type& Source )
      : name( Source.name ),
	comment( Source.comment )
    {
    }

    void FrTableNPS::data_type::
    operator( )( Common::IStream& Stream )
    {
      Stream >> name
	     >> comment
	;
    }

    void FrTableNPS::data_type::
    operator( )( Common::OStream& Stream ) const
    {
      Stream << name
	     << comment
	;
    }

    //=======================================================================
    //=======================================================================

    FrTableNPS::
    FrTableNPS( )
    {
    }

    FrTableNPS::
    FrTableNPS( const FrTableNPS& Source )
      : m_data( Source.m_data )
    {
    }

    //=======================================================================
    //=======================================================================
    FrTable::
    FrTable( )
      : Object( CLASS_ID, StructDescription( ) )
    {
    }

    FrTable::
    FrTable( const FrTable& Table )
      : Object( CLASS_ID, StructDescription( ) ),
	FrTableNPS( Table ),
	FrTablePS( Table )
    {
    }

    FrTable::
    FrTable( const std::string& name, INT_4U nrows )
      : Object( CLASS_ID, StructDescription( ) )
    {
      setName( name );
    }

    FrTable::
    FrTable( const std::string& Name,
	     const std::string& Comment,
	     nRow_type NRows,
	     column_name_container_type ColumnNames )
      : Object( CLASS_ID, StructDescription( ) )
    {
      setName( Name );
      AppendComment( Comment );
    }

    FrTable::
    FrTable( const FrTableNPS& Source )
      :  Object( CLASS_ID, StructDescription( ) ),
	 FrTableNPS( Source )
    {
    }

    FrTable::
    FrTable( istream_type& Stream )
      : Object( CLASS_ID, StructDescription( ) )
    {
      m_data( Stream );
      m_refs( Stream );

      Stream.Next( this );
    }

    FrTable::
    ~FrTable( )
    {
    }

    FrameCPP::cmn_streamsize_type  FrTable::
    Bytes( const Common::StreamBase& Stream ) const
    {
      cmn_streamsize_type retval
	= m_data.Bytes( Stream )
	+ m_refs.Bytes( Stream )
	+ Stream.PtrStructBytes( )	// next
	;
      return retval;
    }

    FrTable* FrTable::
    Create( istream_type& Stream ) const
    {
      return new FrTable( Stream );
    }

    FrTable& FrTable::
    Merge( const FrTable& RHS )
    {
      throw
	Unimplemented( "FrTable& FrTable::Merge( const FrTable& RHS )",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
      return *this;
    }

    FrTable::promote_ret_type FrTable::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     istream_type* Stream )
    {
      return Common::PromoteObject( DATA_FORMAT_VERSION, Source, Obj );
    }

    const char* FrTable::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrTable::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( StructName( ), CLASS_ID, "Table Data Structure" ) );
	
	data_type::Describe< FrSE >( ret );
	refs_type::Describe< FrSE >( ret );

	ret( FrSE( "next", ptr_struct_type::Desc( StructName( ) ) ) );
      }

      return &ret;
    }

    void FrTable::
    Write( ostream_type& Stream ) const
    {
      m_data( Stream );
      m_refs( Stream );

      WriteNext( Stream );
    }

    const std::string& FrTable::
    GetNameSlow( ) const
    {
      return GetName( );
    }

    bool FrTable::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return compare( *this, Obj );
    }

    FrTable& FrTable::
    operator+=( const FrTable& RHS )
    {
      throw Unimplemented( "FrTable& FrTable::operator+=( const FrTable& RHS )",
			   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrTable::demote_ret_type FrTable::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      if ( Target >= DATA_FORMAT_VERSION )
      {
	//-------------------------------------------------------------------
	// Same version
	//-------------------------------------------------------------------
	return Obj;
      }
      else if ( Target < DATA_FORMAT_VERSION )
      {
	//-------------------------------------------------------------------
	// Object does not exist prier to Version 4
	//-------------------------------------------------------------------
	return demote_ret_type( );
      }
      throw
	Unimplemented( "Object* FrTable::Demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrTable::promote_ret_type FrTable::
    promote( INT_2U Source,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      if ( Source <= DATA_FORMAT_VERSION )
      {
	//-------------------------------------------------------------------
	// Object does not exist prier to Version 4
	//-------------------------------------------------------------------
	return promote_ret_type( );
      }
      throw
	Unimplemented( "Object* FrTable::Promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }
  } // namespace - Version_4
} // namespace - FrameCPP
