#ifndef FrameCPP_VERSION_4_FrEndOfFrame_HH
#define FrameCPP_VERSION_4_FrEndOfFrame_HH

#include "general/types.hh"

#include "framecpp/Version4/FrameSpec.hh"

namespace FrameCPP
{
  namespace Version_4
  {
    class FrEndOfFrame
      : public Common::FrameSpec::Object
    {
    public:
      typedef INT_4S run_type;
      typedef INT_4U frame_type;

      //: Default constructor
      FrEndOfFrame( );

      //: Default constructor
      FrEndOfFrame( run_type Run, frame_type Frame );

      static const char* StructName( );

      static const Common::Description* StructDescription( );

      //: Desctructor
      virtual ~FrEndOfFrame( );

      //: Return the number of bytes needed to write this object
      INT_8U Bytes( ) const;

      //: Return run number of frame
      run_type GetRun( ) const;

      //: Return frame number
      frame_type GetFrame( ) const;

      virtual cmn_streamsize_type Bytes( const Common::StreamBase& Stream ) const;

      virtual FrEndOfFrame* Create( istream_type& Stream ) const;

      virtual const char* ObjectStructName( ) const;

      //: Write the structure to the stream
      virtual void Write( ostream_type& Stream ) const;

      /// \brief comparison operator
      bool operator==( const FrEndOfFrame& RHS ) const;

      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      /// \brief Down grade an object
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

    private:
      using Common::FrameSpec::Object::Create;

      struct data_type
      {
	run_type	run;
	frame_type	frame;
      };

      struct data_type m_data;

      FrEndOfFrame( istream_type& Stream );
    };

    inline const char* FrEndOfFrame::
    StructName( )
    {
      static const CHAR* class_name( "FrEndOfFrame" );
      return class_name;
    }

    //: Return run number of frame
    inline FrEndOfFrame::run_type FrEndOfFrame::
    GetRun( ) const
    {
      return m_data.run;
    }

    //: Return frame number
    inline FrEndOfFrame::frame_type FrEndOfFrame::
    GetFrame( ) const
    {
      return m_data.frame;
    }
    
  } // namespace - Version_4
} // namespce - FrameCPP

#endif /* FrameCPP_VERSION_4_FrEndOfFrame_HH */
