/* -*- mode: c++ -*- */
#include "framecpp/config.h"

#include "general/types.hh"
#include "general/SharedArray.hh"

#include "framecpp/Common/Compression.hh"

using General::AutoArray;
using General::SharedArray;

namespace FrameCPP
{
  namespace Compression
  {
    //-------------------------------------------------------------------
    /// \brief Routines related to the differential compression algorithm
    //-------------------------------------------------------------------
    namespace Differential
    {
      template< class T >
      void
      Encode( CHAR_U* Data, INT_4U NData )
      {
	if ( NData > 1 )
	{
	  T*	cur( reinterpret_cast< T* >( Data ) );
	  T*	pre( reinterpret_cast< T* >( Data ) );

	  //---------------------------------------------------------------
	  // Go backwards to eliminate the necisity of temporaries
	  //---------------------------------------------------------------
	  cur = &( cur[ NData - 1 ] );
	  pre = &( pre[ NData - 2 ] );

	  while( cur != (T*)Data )
	  {
	    *cur -= *pre;
	    --cur;
	    --pre;
	  }
	}
      }

      template< class T >
      void
      Encode( const CHAR_U* Data, INT_4U NData, AutoArray< CHAR_U >& Dest )
      {
	Dest.reset( new CHAR_U[ sizeof( T ) * NData ] );

	T* out = reinterpret_cast< T* >( Dest.get( ) );

	if ( NData > 1 )
	{
	  const T*	cur( reinterpret_cast< const T* >( Data ) );
	  const T*	pre( reinterpret_cast< const T* >( Data ) );

	  //---------------------------------------------------------------
	  // Preserve the zeroth element
	  //---------------------------------------------------------------
	  *out = *cur;
	  //---------------------------------------------------------------
	  // Go backwards to eliminate the necisity of temporaries
	  //---------------------------------------------------------------
	  cur = &( cur[ NData - 1 ] );
	  pre = &( pre[ NData - 2 ] );
	  out = &( out[ NData - 1 ] );

	  while( --NData )
	  {
	    *out = *cur - *pre;
	    --cur;
	    --pre;
	    --out;
	  }
	}
      }

      template< class T >
      void
      Encode( const CHAR_U* Data, INT_4U NData, SharedArray< CHAR_U >& Dest )
      {
	Dest.reset( new CHAR_U[ sizeof( T ) * NData ] );

	T* out = reinterpret_cast< T* >( Dest.get( ) );

	if ( NData > 1 )
	{
	  const T*	cur( reinterpret_cast< const T* >( Data ) );
	  const T*	pre( reinterpret_cast< const T* >( Data ) );

	  //---------------------------------------------------------------
	  // Preserve the zeroth element
	  //---------------------------------------------------------------
	  *out = *cur;
	  //---------------------------------------------------------------
	  // Go backwards to eliminate the necisity of temporaries
	  //---------------------------------------------------------------
	  cur = &( cur[ NData - 1 ] );
	  pre = &( pre[ NData - 2 ] );
	  out = &( out[ NData - 1 ] );

	  while( --NData )
	  {
	    *out = *cur - *pre;
	    --cur;
	    --pre;
	    --out;
	  }
	}
      }

      template< class T >
      void
      Decode( CHAR_U* Data, INT_4U NData )
      {
	if ( NData > 1 )
	{
	  T*	pre( reinterpret_cast< T* >( Data ) );
	  T*	cur( &( pre[ 1 ] ) );

	  while( --NData > 0 )
	  {
	    *cur += *pre;
	    ++cur;
	    ++pre;
	  }
	}
      }

      template< class T >
      void
      Decode( const CHAR_U* Data, INT_4U NData, AutoArray< CHAR_U >& Out )
      {
	Out.reset( new CHAR_U[ sizeof( T ) * NData ] );

	T*		out( reinterpret_cast< T* >( Out.get( ) ) );

	const T*	cur( reinterpret_cast< const T* >( Data ) );

	*out = *cur;

	if ( NData > 1 )
	{
	  //---------------------------------------------------------------
	  // Go forward for the decoding process
	  //---------------------------------------------------------------
	  const T*	pre( reinterpret_cast< const T* >( Data ) );

	  out++;
	  cur++;

	  while( --NData > 0 )
	  {
	    *out = *cur + *pre;
	    ++cur;
	    ++pre;
	    ++out;
	  }
	}
      }

      template< class T >
      void
      Decode( const CHAR_U* Data, INT_4U NData, SharedArray< CHAR_U >& Out )
      {
	Out.reset( new CHAR_U[ sizeof( T ) * NData ] );

	std::copy( &(Data[ 0 ]), &(Data[ NData ]), Out.get( ) );
	Decode< T >( Out.get( ), NData );
      }
#define INSTANTIATE( LM_TYPE ) \
      template void Decode< LM_TYPE >( CHAR_U*, INT_4U );		\
      template void Decode< LM_TYPE >( const CHAR_U*, INT_4U,		\
				       AutoArray< CHAR_U >& );		\
      template void Decode< LM_TYPE >( const CHAR_U*, INT_4U,		\
				       SharedArray< CHAR_U >& );	\
      template void Encode< LM_TYPE >( CHAR_U*, INT_4U );		\
      template void Encode< LM_TYPE >( const CHAR_U*, INT_4U,		\
				       AutoArray< CHAR_U >& );		\
      template void Encode< LM_TYPE >( const CHAR_U*, INT_4U,		\
				       SharedArray< CHAR_U >& )
 
      INSTANTIATE( CHAR_U );
      INSTANTIATE( CHAR );
      INSTANTIATE( INT_2U );
      INSTANTIATE( INT_2S );
      INSTANTIATE( INT_4U );
      INSTANTIATE( INT_4S );
      INSTANTIATE( INT_8U );
      INSTANTIATE( INT_8S );
      INSTANTIATE( REAL_4 );
      INSTANTIATE( REAL_8 );

#undef INSTANTIATE
    } // namespace - Differential
    
  } // namespace - Compression

} // namespace - FrameCPP


