#ifndef GENERIC_API__SYMBOL_MAPPER_HH
#define GENERIC_API__SYMBOL_MAPPER_HH

#include <string>

#include "general/unordered_map.hh"

namespace GenericAPI
{
  class SymbolMapper
  {
  public:
    //-------------------------------------------------------------------
    /// <ul>
    ///   <li><b>I</b> Integer parameter</li>
    ///   <li><b>LS</b> List of string parameters</li>
    ///   <li><b>NS</b> Variable name parameter</li>
    ///   <li><b>S</b> String parameter</li>
    /// </ul>
    //-------------------------------------------------------------------
    enum arg_type {
      ARGS_I,
      ARGS_S,
      ARGS_NS,
      ARGS_LS
    };

    typedef void (*func_type)( ... );

    virtual ~SymbolMapper( );

    static inline void
    Add( const std::string& Symbol,
	 arg_type Arg,
	 func_type Function )
    {
      if ( m_symbol_mapper )
      {
	m_symbol_mapper->add( Symbol, Arg, Function );
	m_symbol_mapper->addSymbol( Symbol, Arg, Function );
      }
    }

    static void OnExit( );

  protected:
    class info
    {
    public:
      ~info( );

      arg_type	s_arg_type;
      func_type	s_function;
    };

    typedef General::unordered_map< std::string, info > symbol_table_type;

    static SymbolMapper*	m_symbol_mapper;

    void add( const std::string& Symbol,
	      arg_type Arg,
	      func_type Function );

    virtual void addSymbol( const std::string& Symbol,
			    arg_type Arg,
			    func_type Function ) = 0;

    const info* lookup( const std::string& Symbol ) const;

  private:
    symbol_table_type	m_symbol_table;
  };

  inline SymbolMapper::info::
  ~info( )
  {
  }

}

#endif /* GENERIC_API__SYMBOL_MAPPER_HH */
