/* -*- mode: c++; c-basic-offset: 3 -*- */
#ifndef RDS_RESAMPLE_FRAME_HH
#define RDS_RESAMPLE_FRAME_HH

#include "framecpp/Common/MD5Sum.hh"
#include "framecpp/FrameH.hh"
#include "framecpp/FrVect.hh"

#include "frameAPI/filereader.hh"
#include "frameAPI/rdsframe.hh"   


namespace Filters   
{
   class ResampleBase;
}

   
//-----------------------------------------------------------------------------
//   
//: Functional to create RDS resampled frames.
//   
class ResampleRawFrame
   : private RDSFrame
{
public:
   typedef RDSFrame::frame_file_container_type	frame_file_container_type;
   typedef RDSFrame::channel_container_type	channel_container_type;
   typedef std::vector< INT_4U >		resample_container_type;

   ResampleRawFrame( const char* frame_files, 
                     const char* channels,
                     const char* resample,
		     const RDSFrame::Options& UserOptions );

   //---------------------------------------------------------------------------
   /// \brief Constructor.
   ///
   /// \param[in] frame_files
   ///     A list of frame file names.
   /// \param[in] channels
   ///     A list of channels to extract from  original frames
   ///     (only channel names are allowed).
   /// \param[in] resampling
   ///     A list of resampling values which corrisponds to the channels.
   /// \param[in] UserOptions
   ///     User specified options.
   //---------------------------------------------------------------------------
   ResampleRawFrame( const frame_file_container_type& frame_files, 
		     const channel_container_type& channels,
		     const resample_container_type& resampling,
		     const RDSFrame::Options& CommandOptions );

   virtual ~ResampleRawFrame();
   
   // Expose the main hook for processing information
   using RDSFrame::ProcessRequest;

protected:
   
   virtual void processChannel( INT_4U ChannelOffset,
				fr_adc_data_type Adc );

   virtual void processChannel( INT_4U ChannelOffset,
				fr_proc_data_type Proc );
			
private:
   // Useful typedefs:
   typedef std::vector< Filters::ResampleBase* >::const_iterator
   state_const_iterator;
   typedef std::vector< Filters::ResampleBase* >::iterator 
   state_iterator;   

   //: String representation of all resample factors.
   std::string mResampleRecord;
   
   //: Vector of all resample factors.
   resample_container_type mResampleFactor;      

   //: Vector of base objects used for channel resampling.
   std::vector< Filters::ResampleBase* > mResampleBase;

#if 0
   //: Index of the current channel
   INT_4U	mChannelOffset;
#endif /* 0 */

   //: Dt of the current frame
   REAL_8 mCurrentDt;
   
   //: Current new frame
   frame_h_type			mCurrentFrame;
   
#if 0
   //: Boolean for state of seeding resampling stuctures.
   bool		mSeedState;
#endif /* 0 */

   bool		m_should_write;

   INT_4U	m_is_last_frame_of_file;

   // Create frame
   virtual void createHistory( );
   
   // Initialization
   void initResampleFactor( );

   // Mutators
   void adjustChannelData();   
   
   void adjustResultChannel( const std::string& name,
			     const Filters::ResampleBase* state );

#if 0
   // Open a frame file
   virtual void openFrameFile( const std::string& Filename );
#endif /* 0 */

   virtual void writeFrameToFile( );
};

namespace FrameAPI
{
   namespace RDS
   {
      typedef ResampleRawFrame::channel_container_type channel_container_type;
      typedef ResampleRawFrame::resample_container_type resample_container_type;

      void ExpandChannelList( channel_container_type& Channels,
			      resample_container_type& ResampleRates,
			      const std::string& SampleFrame );
   }
}

   
#endif   
