/* -*- mode: c++; c-basic-offset: 3 -*- */
#ifndef RDS_REDUCE_FRAME_HH
#define RDS_REDUCE_FRAME_HH

#include "frameAPI/rdsframe.hh"   

//-----------------------------------------------------------------------------
//   
//: Functional to create RDS frames.
//   
class ReduceRawFrame
   : private RDSFrame
{
public:
   //---------------------------------------------------------------------------
   /// \brief Constructor.
   ///
   /// \param[in] frame_files
   ///     A list of frame file names.
   /// \param[in] channels
   ///     A list of channels to extract from  original frames
   ///     (only channel names are allowed).
   /// \param[in] UserOptions
   ///     User specified options.
   //---------------------------------------------------------------------------
   ReduceRawFrame( const char* frame_files, 
                   const char* channels,
		   const RDSFrame::Options& CommandOptions );

   //---------------------------------------------------------------------------
   /// \brief Constructor.
   ///
   /// \param[in] frame_files
   ///     A list of frame file names.
   /// \param[in] channels
   ///     A list of channels to extract from  original frames
   ///     (only channel names are allowed).
   /// \param[in] UserOptions
   ///     User specified options.
   //---------------------------------------------------------------------------
   ReduceRawFrame( const frame_file_container_type& frame_files, 
                   const channel_container_type& channels,
		   const RDSFrame::Options& CommandOptions );

   //---------------------------------------------------------------------------
   /// \brief Destructor
   //---------------------------------------------------------------------------
   virtual ~ReduceRawFrame();
   
   // Expose the main hook for processing information
   using RDSFrame::ProcessRequest;

protected:
   virtual void processChannel( INT_4U ChannelOffset,
				fr_adc_data_type Adc );

   virtual void processChannel( INT_4U ChannelOffset,
				fr_proc_data_type Proc );
};

#endif   
