#include "createRDS.hh"
#include "Frame.hh"
#include "rdsframe.hh"
#include "rdsreduce.hh"
#include "rdsresample.hh"
#include "RDSStreamFile.hh"
#include "RDSStreamFileReduce.hh"
#include "RDSStreamFileResample.hh"
#include "RDSStreamMemory.hh"

namespace FrameAPI
{
  Frame
  createRDSFrame( const frame_file_container_type& FrameFiles,
		  start_type Start,
		  end_type End,
		  const channel_container_type& Channels )
  {
    RDS::Options
      opts( Start,		// Start Time
	    End,		// End Time
	    "__none__",		// Output Type
	    "",			// Compression - raw
	    0,			// Compression - level
	    false,		// Verify Checksum
	    false,		// Verify Frame Checksum
	    false,		// Verify Time Range
	    false,		// Verify Data Valid
	    1,			// FramesPerFile
	    End - Start,	// SecondsPerFrame
	    true,		// AllowShortFrames
	    false,		// GenerateFrameChecksum
	    true,		// FillMissingDataValidArray
	    false );		// VerifyFilenameMetadata

    RDSStreamMemory*
      stream( new RDSStreamMemory( ) );

    RDSFrame::stream_type	output;
    Frame			retval;

    output.reset( stream );
    ReduceRawFrame
      request( FrameFiles,	// Filename list
	       Channels.names,	// Channel list
	       opts );
    request.ProcessRequest( output );
    if ( output )
    {
      retval = stream->Results( )[ 0 ];
    }

    return retval;
  }

  void
  createRDSSet( const frame_file_container_type& FrameFiles,
		const channel_container_type& Channels,
		const FrameAPI::RDS::FileOptions& Opts )
  {
    bool	need_to_resample = false;

    for ( channel_container_type::resampling_type::const_iterator
	    cur = Channels.resampling.begin( ),
	    last = Channels.resampling.end( );
	  cur != last;
	  ++cur )
    {
      if ( *cur != 1 )
      {
	need_to_resample = true;
	break;
      }
    }
    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    try
    {
      if ( need_to_resample )
      {
	std::cerr << "DEBUG: Resampling"
		  << std::endl
	  ;
	//---------------------------------------------------------------
	// Resample
	//---------------------------------------------------------------
	RDSStreamFileResample*
	  fstream( new RDSStreamFileResample( Opts.DirectoryOutputFrames( ),
					      Opts.OutputType( ).c_str( ), // OutputType
					      1, // RDSLevel
					      Opts.DirectoryOutputMD5Sum( ) ) );
	RDSFrame::stream_type	stream( fstream );

	ResampleRawFrame
	  request( FrameFiles,		// Filename list
		   Channels.names,	// Channel list
		   Channels.resampling,	// Resampling
		   Opts );
	request.ProcessRequest( stream );
      }
      else
      {
	RDSStreamFileReduce*
	  fstream( new RDSStreamFileReduce( Opts.DirectoryOutputFrames( ),
					    Opts.OutputType( ).c_str( ), // OutputType
					    1, // RDSLevel
					    Opts.DirectoryOutputMD5Sum( ) ) );
	RDSFrame::stream_type	stream( fstream );

	std::cerr << "DEBUG: Reducing"
		  << std::endl
	  ;
	//---------------------------------------------------------------
	// Reduce
	//---------------------------------------------------------------
	ReduceRawFrame
	  request( FrameFiles,		// Filename list
		   Channels.names,	// Channel list
		   Opts );
	std::cerr << "DEBUG: Reducing: Created instance"
		  << std::endl
	  ;
	request.ProcessRequest( stream );
	std::cerr << "DEBUG: Reducing: Processed Request"
		  << std::endl
	  ;
      }
    } 
    catch( const std::exception& E )
    {
      std::cerr << "DEBUG: Caught excpetion: " << E.what( )
		<< std::endl
	;
      throw;
    }
  }
}
