/* -*- mode: c++; c-basic-offset: 3; indent-tabs-mode: nil; -*- */
#include "general/AtExit.hh"

#include "counter.hh"
   
using namespace diskCache;
using namespace General;
   
   
//------------------------------------------------------------------------------
//      
//: Constructor
//
// Increments counter by 1.
//
diskCache::ThreadCounter::ThreadCounter( INT_2S& counter,
   General::ReadWriteLock::lock_type& lock )
   : mCounter( counter ), mCounterLock( lock )
{
   ReadWriteLock counter_lock( mCounterLock, ReadWriteLock::WRITE,
			      __FILE__, __LINE__ );
   ++mCounter;
}   
   

//------------------------------------------------------------------------------
//      
//: Destructor
//
// Decrements counter by 1.
//
diskCache::ThreadCounter::~ThreadCounter()
{
   ReadWriteLock counter_lock( mCounterLock, ReadWriteLock::WRITE,
                               __FILE__, __LINE__ );
      
   --mCounter;
}   
      
