#ifdef HAVE_CONFIG_H
#include <ldasgen_config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>

#include <iostream>
#include <sstream>

#include "ldastoolsal/Directory.hh"

#include "genericAPI/StatFork.hh"
#include "genericAPI/StatStream.hh"

static const char* class_name = "StatFork";

namespace GenericAPI
{
  StatFork::
  StatFork( )
    : m_cmd( LIBEXECDIR "/ldas/lstat" )
  {
  }

  StatFork* StatFork::
  vnew( ) const
  {
    return new StatFork( );
  }

  std::string StatFork::
  Debug( debug_info DebugInfo ) const
  {
    std::ostringstream	msg;

    switch( DebugInfo )
    {
    case STAT_DEBUG_GENERAL:
    default:
      msg << class_name << ": " << (void*)this
	  << " ChildPid: " << ChildPid( );
    }

    return msg.str( );
  }

  void StatFork::
  Init( )
  {
    Spawn( );
  }

  int StatFork::
  LStat( const std::string& Filename, struct stat& Buf ) const
  {
    if ( isParent( ) )
    {
      StatStream	stream;

      return stream.Request( getStdOut( ), getStdIn( ), Filename, Buf );
    }
    errno = EFAULT;
    return -1;
  }

  int StatFork::
  LStat( const directory_type& Dir,
	 const std::string& RelFilename,
	 stat_buf_type& Buf ) const
  {
    std::string filename( Dir.Name( ) );

    filename += "/" + RelFilename;
    return LStat( filename, Buf );
  }

  int StatFork::
  Stat( const std::string& Filename, struct stat& Buf ) const
  {
    if ( isParent( ) )
    {
      StatStream	stream;

      return stream.Request( getStdOut( ), getStdIn( ), Filename, Buf );
    }
    errno = EFAULT;
    return -1;
  }

  int StatFork::
  Stat( const directory_type& Dir,
	const std::string& RelFilename,
	stat_buf_type& Buf ) const
  {
    std::string filename( Dir.Name( ) );

    filename += "/" + RelFilename;
    return Stat( filename, Buf );
  }

  void StatFork::
  evalChild( )
  {
    //-------------------------------------------------------------------
    // Replace stdin with pipe
    //-------------------------------------------------------------------
    close( 0 );	// Close stdin
    if( dup( getStdIn( ) ) == -1 )
    {
      _exit( 1 );
    }
    close( getStdIn( ) );

    //-------------------------------------------------------------------
    // Replace stdout with pipe
    //-------------------------------------------------------------------
    close( 1 ); // Close stdout
    if ( dup( getStdOut( ) ) == -1 )
    {
      _exit( 1 );
    }
    close( getStdOut( ) );

    //-------------------------------------------------------------------
    // Need to start the lstat process
    //-------------------------------------------------------------------
    execl( m_cmd.c_str( ), m_cmd.c_str( ), (const char*)NULL );
  }

  void StatFork::
  evalParent( )
  {
    //-------------------------------------------------------------------
    // Nothing to do.
    //-------------------------------------------------------------------
  }
}
