/* -*- mode: c++ -*- */

#if defined(SWIGPYTHON)

 // =====================================================================
 //  Setup for Python
 // =====================================================================

%begin %{
extern "C"
{
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "framecpp_config.h"

#include <Python.h>

#if HAVE_NUMPY_ARRAYOBJECT_H
#include <numpy/arrayobject.h>
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
} /* extern "C" */
%}
%{
#include "framecpp/IFrameStream.hh"
#include "framecpp/OFrameStream.hh"
#include "framecpp/GPSTime.hh"

#if HAVE_NUMPY_ARRAYOBJECT_H
#include <numpy/arrayobject.h>
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */

using namespace FrameCPP;

#if HAVE_NUMPY_ARRAYOBJECT_H
#define FRAMECPP_INIT_RETVAL PyMODINIT_FUNC
#else /* HAVE_NUMPY_ARRAYOBJECT_H */
#define FRAMECPP_INIT_RETVAL static void
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
FRAMECPP_INIT_RETVAL
framecpp_init( )
{
#if HAVE_NUMPY_ARRAYOBJECT_H
  import_array( );
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
}
%}

%{
#include "framecpp/FrVect.hh"

#if 0
  static bool data_type_validation_error = false;

  template< class T, class V>
  inline
  void validate_data_type( const char* ClassInfo, const char* Member )
  {
    if ( typeid( T ) != typeid( V ) )
    {
      std::cerr << "ERROR: " << ClassInfo << "::" << Member
		<< " is of the wrong type"
#if WORKING
		<< " ( " << typeid(T).name( )
		<< " != " << typeid(V).name( ) << " )"
#endif /* WORKING */
		<< std::endl;
      data_type_validation_error = true;
    }
  }

#define VALIDATE_DATA_TYPE(CLASS,MEMBER,REF)	\
  validate_data_type<CLASS::MEMBER, REF>( #CLASS , #MEMBER )
#endif /* 0 */
%}
%init {
  framecpp_init( );
}

%{
#include <wchar.h>
%}

 // =====================================================================
 //  Make sure that no exceptions leak out
 // =====================================================================

%exception
{
  //---------------------------------------------------------------------
  // Ensure that no exceptions leave the C++ layer
  //---------------------------------------------------------------------
  try
  {
    $action;
  }
  catch( const std::exception& Exception )
  {
    //-------------------------------------------------------------------
    // Handle exceptions derived from std::exception
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( Exception.what( ) ) );
    goto fail;
  }
  catch( ... )
  {
    //-------------------------------------------------------------------
    // Catch everything else to make sure they do not leak outside
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( "unknown error" ) );
    goto fail;
  }
}

%typemap(in) IFrameFStream::size_type {
  $1 = PyInt_AsLong( $input );
}

%typemap(out) IFrameFStream::size_type {
  $result = PyInt_FromLong( $1 );
}

%define LDAS_PROPERTY_READ_ONLY(Name,ReadFunc)
  %insert("python") %{
     __swig_getmethods__[Name] = ReadFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

%define LDAS_PROPERTY_READ_WRITE(Name,ReadFunc,WriteFunc)
  %insert("python") %{
    __swig_getmethods__[Name] = ReadFunc
    __swig_setmethods__[Name] = WriteFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

 //::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
 // MAKE_REF
 //::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
%define MAKE_REF(KLASS,BASE,base)
%{
  const KLASS ## :: ## base ## _type&
  KLASS ## _Ref ## BASE( KLASS * Source )
  {
    return Source->Ref ## BASE( );
  }

  size_t KLASS ## _Ref ## BASE ## Size( KLASS * Source )
  {
    return Source->Ref ## BASE( ).size( );
  }
%}
%enddef

 //::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
 // TYPEDEF_CONTAINER
 //::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
%define TYPEDEF_CONTAINER(KLASS, NAME)
  typedef std::vector< LDASTools::AL::SharedPtr< KLASS > > NAME
%enddef

 // =====================================================================
 //  Pull in additional language specific rules
 // =====================================================================

%import FrProcData_python.i

 // =====================================================================
 //  Pull in the core wrappings
 // =====================================================================

%include "framecpp/frameCPP.i"

#endif /* defined(SWIGPYTHON) */
