/* -*- mode: c++ -*- */
/** \cond IGNORE_BY_DOXYGEN */
#if ! SWIGIMPORTED
%define DOCSTRING
"The frameCPP package for Python allows for Python
developers to interface with the frameCPP library."
"The specification on which this interface is based can be found at:"
"https://dcc.ligo.org/cgi-bin/private/DocDB/ShowDocument?docid=329"
%enddef
#endif /* SWIGIMPORTED */

%module(docstring=DOCSTRING) frameCPP
%feature("autodoc","1");

%include "framecpp/frameCPPMacros.i"

%include "ldastoolsal/SharedPtr.i"
%include "framecpp/DataTypes.i"
%include "framecpp/GPSTime.i"
%include "framecpp/STRING.i"
%include "framecpp/Dimension.i"

%include "framecpp/Container.i"
%include "framecpp/SearchContainer.i"

%SharedPtr(FrameH)
%SharedPtr(FrAdcData)
%SharedPtr(FrDetector)
%SharedPtr(FrEvent)
%SharedPtr(FrHistory)
%SharedPtr(FrProcData)
%SharedPtr(FrSimData)
%SharedPtr(FrTable)
%SharedPtr(FrVect)

%include "framecpp/FrVect.i"
%include "framecpp/FrAdcData.i"
%include "framecpp/FrDetector.i"
%include "framecpp/FrEvent.i"
%include "framecpp/FrHistory.i"
%include "framecpp/FrProcData.i"
%include "framecpp/FrSimData.i"
%include "framecpp/FrTable.i"
%include "framecpp/FrTOC.i"

%include "framecpp/FrameH.i"

%include "framecpp/Detectors.i"

%include "framecpp/IFrameFStream.i"
%include "framecpp/OFrameFStream.i"

/** \endcond IGNORE_BY_DOXYGEN */
