/* -*- mode: c++ -*- */
#ifndef SWIG__COMMON__FR_TABLE_I
#define SWIG__COMMON__FR_TABLE_I

%module frameCPP

%{
#include "ldastoolsal/types.hh"
#include "framecpp/FrTable.hh"

using namespace FrameCPP;
%}

%import "framecpp/FrameCPP.hh"
%import "framecpp/FrTable.hh"

%import "SearchContainer.i"
%import "FrVect.i"

%feature("autodoc",
"""
FrTable implementation of the frame specification.

  Attributes:

    name           Name of simulated data.
    comment        Comment.
    column         Array of columns of table.
""" ) FrTable;

class FrTable
{
public:
  TYPEDEF_CONTAINER(FrVect,column_type);

  FrTable( );
  FrTable( const std::string& name, INT_4U nrows );

  const std::string& GetName() const; 
  const std::string& GetComment( ) const;

  %extend {
    const column_type& RefColumn( );
  }

  LDAS_PROPERTY_READ_ONLY("name",GetName)
  LDAS_PROPERTY_READ_ONLY("comment",GetComment)

  LDAS_PROPERTY_READ_ONLY("column", RefColumn)
};

#if ! SWIGIMPORTED

MAKE_REF(FrTable,Column,column)

CONTAINER_WRAP(FrTable,FrTable)

#endif /* SWIGIMPORTED */

#endif /* SWIG__COMMON__FR_TABLE_I */
