#include <framecpp_config.h>

#include <memory>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/STRING.hh"

#include "framecpp/Version3/FrameSpec.hh"

#include "framecpp/Version3/FrSH.hh"

#include "Common/ComparePrivate.hh"

using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::Description;

namespace FrameCPP
{
  namespace Version_3
  {
    FrSH::
    FrSH( )
      : Common::FrSH( )
    {
    }


    FrSH::
    FrSH( const std::string& Name, INT_2U ClassId, const std::string& Comment )
      : Common::FrSH( )
    {
      m_data.name = Name;
      m_data.classId = ClassId;
      m_data.comment = Comment;
    }

    FrSH::
    FrSH( istream_type& Stream )
    {
      Stream >> m_data.name
	     >> m_data.classId
	     >> m_data.comment
	;
    }

    FrSH::
    ~FrSH( )
    {
    }

    INT_8U FrSH::
    Bytes( const Common::StreamBase& Stream ) const
    {
      INT_8U retval =
	m_data.name.Bytes( ) +
	sizeof( m_data.classId ) +
	m_data.comment.Bytes( );

      return retval;
    }

    FrSH* FrSH::
    Create( istream_type& Stream ) const
    {
      return new FrSH( Stream );
    }

    FrSH* FrSH::
    Clone( ) const
    {
      return new FrSH( *this );
    }

    const char* FrSH::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    void FrSH::
    Write( ostream_type& Stream ) const
    {
      Stream << m_data.name
	     << m_data.classId
	     << m_data.comment;
    }

    bool FrSH::
    operator==( const FrSH& RHS ) const
    {
      return ( ( m_data.name == RHS.m_data.name )
	       && ( m_data.classId == RHS.m_data.classId )
	       && ( m_data.comment == RHS.m_data.comment ) );
    }

    bool FrSH::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return Common::Compare( *this, Obj );
    }

    void FrSH::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    {
      using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
      va_list	vl;
      va_start( vl, InfoClass );
#endif /* WORKING_VIRTUAL_TOCQUERY */
      while ( InfoClass != TOCInfo::IC_EOQ )
      {
	int data_type = va_arg( vl, int );
	switch( data_type )
	{
	case TOCInfo::DT_STRING_2:
	  {
	    Common::STRING< INT_2U >*
	      data = va_arg( vl, Common::STRING< INT_2U >* );
	    *data = GetName( );
	  }
	  break;
	case TOCInfo::DT_INT_2U:
	  {
	    INT_2U*	data = va_arg( vl, INT_2U* );
	    *data = GetClass( );
	  }
	  break;
	default:
	  // Stop processing
	  InfoClass = TOCInfo::IC_EOQ;
	  continue;
	}
	InfoClass = va_arg( vl, int );
      }
#if WORKING_VIRTUAL_TOCQUERY
      va_end( vl );
#endif /* WORKING_VIRTUAL_TOCQUERY */
    }

    const std::string& FrSH::
    name( ) const
    {
      return GetName( );
    }

    INT_2U FrSH::
    classId( ) const
    {
      return GetClass( );
    }

    void FrSH::
    assign( assign_stream_type& Stream )
    {
      Stream >> m_data.name
	     >> m_data.classId
	     >> m_data.comment
	;
    }

    FrSH::demote_ret_type FrSH::
    demote( INT_2U Target, 
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSH::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrSH::promote_ret_type FrSH::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSH::promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }
  } // namespace - Version_3
} // namespace - FrameCPP
