dnl======================================================================
dnl AX_LDAS_PROG_ABI_COMPLIANCE_CHECKER
dnl======================================================================
AC_DEFUN([AX_LDAS_PROG_ABI_COMPLIANCE_CHECKER],
[ AC_CACHE_CHECK([whether abi-compliance-checker command works],
	         [ldas_cv_shell_abi_compliance_checker],
	         [AC_ARG_WITH([abi-compliance-checker],
			      [AS_HELP_STRING([--with-abi-compliance-checker],
					      [enable support for the abi-compliance-checker command])],
			      [],
			      [with_abi_compliance_checker=yes])
		  AS_IF([test "x$with_abi_compliance_checker" = xyes],
		  	[AC_PATH_PROGS( ldas_cv_shell_abi_compliance_checker, abi-compliance-checker )],
			[AS_IF([test "x$with_abi_compliance_checker" != xno],
			       [ldas_cv_shell_abi_compliance_checker="$with_abi_compliance_checker"])])
  	          case x$ldas_cv_shell_abi_compliance_checker in
                  x) ldas_cv_shell_abi_compliance_checker="no";;
                  *) ( $ldas_cv_shell_abi_compliance_checker < /dev/null ) 2>/dev/null || ldas_cv_shell_abi_compliance_checker=""
	             ;;
		  esac])
  ABI_COMPLIANCE_CHECKER="$ldas_cv_shell_abi_compliance_checker"
  case x$ABI_COMPLIANCE_CHECKER in
  x|xno) unset ABI_COMPLIANCE_CHECKER;;
  *)
    ABI_COMPLIANCE_CHECKER_PATH="`echo $ABI_COMPLIANCE_CHECKER | sed -e 's,/[^/]*$,,'`"
    ;;
  esac
  AC_SUBST([ABI_COMPLIANCE_CHECKER_PATH])
  AC_SUBST([ABI_COMPLIANCE_CHECKER])
  AM_CONDITIONAL([HAVE_ABI_COMPLIANCE_CHECKER],[test x$ABI_COMPLIANCE_CHECKER != x])
])
