#ifndef FRAMECPP__TEST__STANDARD_OPTIONS_HH
#define FRAMECPP__TEST__STANDARD_OPTIONS_HH

#include <sstream>

#include "ldastoolsal/CommandLineOptions.hh"

namespace {
  enum {
    STANDARD_OPTION_BLOCK_SIZE,
    STANDARD_OPTION_HELP,
    STANDARD_OPTION_SILENT_DATA,
    STANDARD_OPTION_TOC_OPT,
    STANDARD_OPTION_USE_MMAP
  };

  template< int > void StandardOption( LDASTools::AL::CommandLineOptions::OptionSet& Options, int Id );

  template< int > void StandardOption( LDASTools::AL::CommandLineOptions::OptionSet& Options,
				       int Id,
				       size_t Default );

  template< int > void StandardOption( LDASTools::AL::CommandLineOptions::OptionSet& Options,
				       int Id,
				       bool Default );
}

namespace {
  typedef LDASTools::AL::CommandLineOptions::OptionSet OptionSet;
 
  template< >
  inline void
  StandardOption< STANDARD_OPTION_HELP >( OptionSet& Options, int Id )
  {
    Options.Add( OptionSet::element_type( Id,
					  "help",
					  OptionSet::element_type::ARG_NONE,
					  "Display this message" ) );
  }

  template< >
  inline void
  StandardOption< STANDARD_OPTION_BLOCK_SIZE >( OptionSet& Options, int Id, size_t Default )
  {
    std::ostringstream	desc;

    desc <<
      "Number of 1k blocks to use for io."
      " (Default: " << Default << " )"
      ;
    Options.
      Add( OptionSet::element_type( Id,
				    "bs",
				    OptionSet::element_type::ARG_REQUIRED,
				    desc.str( ),
				    "<block_size>" ) );
  }

  template< >
  inline void
  StandardOption< STANDARD_OPTION_SILENT_DATA >( OptionSet& Options, int Id, bool Default )
  {
    std::ostringstream	desc;

    desc <<
      "Supress the output of the data element of the FrVect structure."
      " (Default: " << ( ( Default )
			 ? "silent"
			 : "verbose" ) << " )"
    ;

    Options.Add( OptionSet::element_type( Id,
					  "silent-data",
					  OptionSet::element_type::ARG_NONE,
					  desc.str( ) ) );
  }

  template< >
  inline void
  StandardOption< STANDARD_OPTION_TOC_OPT >( OptionSet& Options, int Id, bool Default )
  {
    std::ostringstream	desc;

    desc <<
      "Use table of contents optimization."
      " (Default: " << ( ( Default )
			 ? "enabled"
			 : "disabled" ) << " )"
    ;
    Options.Add( OptionSet::element_type( Id,
					  "toc-opt",
					  OptionSet::element_type::ARG_NONE,
					  desc.str( ) ) );
  }

  template< >
  inline void
  StandardOption< STANDARD_OPTION_USE_MMAP >( OptionSet& Options, int Id, bool Default )
  {
    std::ostringstream	desc;

    desc <<
      "Use memory mapped io."
      " (Default: " << ( ( Default )
			 ? "enabled"
			 : "disabled" ) << " )"
    ;

    Options.Add( OptionSet::element_type( Id,
					  "use-mmap",
					  OptionSet::element_type::ARG_NONE,
					  desc.str( ) ) );
  }
}

#endif /* FRAMECPP__TEST__STANDARD_OPTIONS_HH */
