#include <framecpp_config.h>

#include <algorithm>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrStatData.hh"
#include "framecpp/Version8/FrDetector.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/PTR_STRUCT.hh"

#include "Common/ComparePrivate.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;

//=======================================================================
// FrStatData
//=======================================================================

namespace FrameCPP
{
  namespace Version_8
  {
    FrStatData::
    FrStatData( )
      : object_type( StructDescription( ) )
    {
    }

    FrStatData::
    FrStatData( const FrStatData& Source )
      : object_type( StructDescription( ) ),
	FrStatDataNPS( Source ),
	FrStatDataPS( Source ),
	Common::TOCInfo( Source )
    {
    }

    FrStatData::
    FrStatData( const std::string& name,
		const std::string& comment,
		const std::string& representation,
		const INT_4U timeStart,
		const INT_4U timeEnd,
		const INT_4U version )
      : object_type( StructDescription( ) ),
	FrStatDataNPS( name, comment, representation,
		       timeStart, timeEnd, version )
    {
    }

    FrStatData::
    FrStatData( const Previous::FrStatData& Source,
		istream_type* Stream )
      : object_type( StructDescription( ) )
    {
      m_data( Source );
      if ( Stream )
      {
	//-------------------------------------------------------------------
	// Modify references
	//-------------------------------------------------------------------
	const INT_2U max_ref = Previous::FrStatData::MAX_REF;
	Stream->ReplacePtr( AddressOfDetector( ),
			    Source.AddressOfDetector( ),
			    max_ref );
	Stream->ReplaceRef( RefData( ), Source.RefData( ), max_ref );
	Stream->ReplaceRef( RefTable( ), Source.RefTable( ), max_ref );
      }
    }

    FrStatData::
    FrStatData( istream_type& Stream )
      : object_type( StructDescription( ) )
    {
      m_data( Stream );
      m_refs( Stream );
    }

    FrStatData* FrStatData::
    Clone( ) const
    {
      return new FrStatData( *this );
    }

    const char* FrStatData::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrStatData::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( FrStatData::StructName( ), FrStatData::STRUCT_ID,
		   "Static Data Structure" ) );

	FrStatDataNPS::storage_type::Describe< FrSE >( ret );
	ref_type::Describe< FrSE >( ret );

	ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
      }

      return &ret;
    }

    void FrStatData::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
      vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    {
      using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
      va_list	vl;
      va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      while ( InfoClass != TOCInfo::IC_EOQ )
      {
	int data_type = va_arg( vl, int );
	switch( data_type )
	{
	case TOCInfo::DT_STRING_2:
	  {
	    STRING* data = va_arg( vl, STRING* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_NAME:
	      *data = GetName( );
	      break;
	    case TOCInfo::IC_DETECTOR:
	      if ( GetDetector( ) )
	      {
		LDASTools::AL::SharedPtr< FrDetector >
		  detector( LDASTools::AL::DynamicPointerCast< FrDetector >
			    ( GetDetector( ) ) );

		*data = detector->GetName( );
	      }
	      else
	      {
		*data = "";
	      }
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	case TOCInfo::DT_INT_4U:
	  {
	    INT_4U* data = va_arg( vl, INT_4U* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_START:
	      *data = GetTimeStart( );
	      break;
	    case TOCInfo::IC_END:
	      *data = GetTimeEnd( );
	      break;
	    case TOCInfo::IC_VERSION:
	      *data = GetVersion( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	default:
	  // Stop processing
	  goto cleanup;
	}
	InfoClass = va_arg( vl, int );
      }
    cleanup:
#if WORKING_VIRTUAL_TOCQUERY
      va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
	;
    }

    FrStatData& FrStatData::
    Merge( const FrStatData& RHS )
    {
      //:TODO: Need to implement Merge routine
      std::string msg( "Merge currently not implemented for " );
      msg += StructName( );

      throw std::domain_error( msg );
      return *this;
    }


    bool FrStatData::
    operator==( const Common::FrameSpec::Object& RHS ) const
    {
      return Common::Compare( *this, RHS );
    }

    FrStatData::demote_ret_type FrStatData::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      if ( Target >= DATA_FORMAT_VERSION )
      {
	return Obj;
      }
      try
      {
	//-------------------------------------------------------------------
	// Copy non-reference information
	//-------------------------------------------------------------------
	// Do actual down conversion
	LDASTools::AL::SharedPtr< Previous::FrStatData >
	  retval( new Previous::FrStatData( GetName( ),
					    GetComment( ),
					    GetRepresentation( ),
					    GetTimeStart( ),
					    GetTimeEnd( ),
					    GetVersion( )
					    ) )
	  ;
	if ( Stream )
	{
	  //-----------------------------------------------------------------
	  // Modify references
	  //-----------------------------------------------------------------
	  Stream->ReplacePtr( retval->AddressOfDetector( ),
			      AddressOfDetector( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefData( ), RefData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefTable( ), RefTable( ), MAX_REF );
	}
	//-------------------------------------------------------------------
	// Return demoted object
	//-------------------------------------------------------------------
	return retval;
      }
      catch( ... )
      {
      }
      throw
	Unimplemented( "Object* FrStatData::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrStatData::promote_ret_type FrStatData::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      return Promote( Target, Obj, Stream );
    }

    FrameCPP::cmn_streamsize_type FrStatData::
    pBytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.Bytes( )
	+ m_refs.Bytes( Stream )
	;
    }

    FrStatData* FrStatData::
    pCreate( istream_type& Stream ) const
    {
      return new FrStatData( Stream );
    }

    void FrStatData::
    pWrite( ostream_type& Stream ) const
    {
      m_data( Stream );
      m_refs( Stream );
    }

  } // namespace - Version_8
} // namespace - FrameCPP
