#ifndef FrameCPP_VERSION_4_FrTOCSerData_HH
#define FrameCPP_VERSION_4_FrTOCSerData_HH

#include "framecpp/Version4/FrTOCPosition.hh"
#include "framecpp/Version4/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_4
  {
    //===================================================================
    //===================================================================
    class FrTOCSerData
      : public FrTOCPosition
    {
    public:
      typedef FrTOCPosition::n_type		nser_type;
      typedef FrTOCPosition::position_type	position_type;

      typedef FrTOCPosition::info_type	ser_info_type;
      typedef FrTOCPosition::Map_type	MapSer_type;

      FrTOCSerData( );

      template< typename SE >
      static void Description( Common::Description& Desc );

      const MapSer_type& GetSer( ) const;

      MapSer_type::const_iterator GetSer( const std::string& Name ) const;

      MapSer_type::const_iterator GetSer( INT_4U index ) const;

      void QuerySer( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

      bool operator==( const FrTOCSerData& RHS ) const;

    protected:
      FrTOCSerData( Common::IStream& Stream, INT_4U FrameCount );
      void write( Common::OStream& Stream ) const;
    };

    inline FrTOCSerData::
    FrTOCSerData( )
    {
    }

    inline FrTOCSerData::
    FrTOCSerData( Common::IStream& Stream, INT_4U FrameCount )
      : FrTOCPosition( Stream, FrameCount )
    {
    }

    template< typename SE >
    void FrTOCSerData::
    Description( Common::Description& Desc )
    {
      Desc( SE( "nSer", "INT_4U",
		"Number of unique FrSerData names in file." ) );
      Desc( SE( "nameSer", "*STRING", "Array of FrSerData names" ) );
      Desc( SE( "positionSer", "*INT_8U",
		"Array of lists of FrSerData offset positions, in bytes,"
		" from beginning of file (size of nFrame*nSer)"
		) );
    }

    inline const FrTOCSerData::MapSer_type& FrTOCSerData::
    GetSer( ) const
    {
      return getInfo( );
    }

    inline FrTOCSerData::MapSer_type::const_iterator FrTOCSerData::
    GetSer( const std::string& Channel ) const
    {
      return getInfo( Channel );
    }

    inline FrTOCSerData::MapSer_type::const_iterator FrTOCSerData::
    GetSer( INT_4U Channel ) const
    {
      return getInfo( Channel );
    }

    inline void FrTOCSerData::
    write( Common::OStream& Stream ) const
    {
      FrTOCPosition::write( Stream );
    }
  } // namespace - Version_4
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_4_FrTOCSerData_HH */
