#ifndef FRAMECPP__COMMON__CRC_HH
#define FRAMECPP__COMMON__CRC_HH

#define NEW_CRC 0

#if NEW_CRC
#include <stdint.h>

#include <cstdlib>

#include "ldastoolsal/reverse.hh"
#include "framecpp/Common/CRCModel.hh"

namespace FrameCPP
{
  namespace Common
  {
    template < typename MODEL >
    class CRC
      : public MODEL
    {
    public:
      typedef typename MODEL::crc_type crc_type;

      void SliceBy1( const void* Data, size_t Length );

      void SliceBy8( const void* Data, size_t Length );

      crc_type Finish( ) const;

    protected:
      CRC( crc_type Source );

      CRC( const CRC& Source );

    private:
      static crc_type	lookup[8][256];

      crc_type		crc;
    };

    template< typename MODEL >
    CRC<MODEL>::
    CRC( crc_type Source)
      : crc( Source ^ MODEL::INITIAL )
    {
    }

    template< typename MODEL >
    CRC<MODEL>::
    CRC( const CRC& Source)
      : crc( Source.crc )
    {
    }

    template< typename MODEL >
    inline typename CRC<MODEL>::crc_type CRC<MODEL>::
    Finish( ) const
    {
      return ( crc ^ MODEL::FINISH );
    }

    template< typename MODEL >
    inline void CRC<MODEL>::
    SliceBy1( const void* Data,
	      size_t Length )
    {
      const uint8_t*
	current( reinterpret_cast< const uint8_t*>( Data ) );

      while( Length-- > 0 )
      {
	crc = ( crc >> 8 ) ^ lookup[0][(crc & 0xFF) ^ *current++];
      }
    }

    template< typename MODEL >
    inline void CRC<MODEL>::
    SliceBy8( const void* Data,
	      size_t Length )
    {
      const crc_type*
	current( reinterpret_cast< const crc_type*>( Data ) );

      // process eight bytes at once (Slicing-by-8)
      while ( Length >= 8 )
      {
#if __BYTE_ORDER == __BIG_ENDIAN
	crc_type one = *current++ ^ bswap(crc);
	crc_type two = *current++;

	crc  =
	  lookup[0][ two      & 0xFF] ^
	  lookup[1][(two>> 8) & 0xFF] ^
	  lookup[2][(two>>16) & 0xFF] ^
	  lookup[3][(two>>24) & 0xFF] ^
	  lookup[4][ one      & 0xFF] ^
	  lookup[5][(one>> 8) & 0xFF] ^
	  lookup[6][(one>>16) & 0xFF] ^
	  lookup[7][(one>>24) & 0xFF];
#else
	crc_type one = *current++ ^ crc;
	crc_type two = *current++;

	crc  =
	  lookup[0][(two>>24) & 0xFF] ^
	  lookup[1][(two>>16) & 0xFF] ^
	  lookup[2][(two>> 8) & 0xFF] ^
	  lookup[3][ two      & 0xFF] ^
	  lookup[4][(one>>24) & 0xFF] ^
	  lookup[5][(one>>16) & 0xFF] ^
	  lookup[6][(one>> 8) & 0xFF] ^
	  lookup[7][ one      & 0xFF];
#endif

	Length -= 8;
      }

      SliceBy1( current, Length );
    }

    //-------------------------------------------------------------------
    // define some standard types
    //-------------------------------------------------------------------
    typedef class CRC< crc32_model_type> crc32_type;
  }
}

#endif /* NEW_CRC */

#endif /* FRAMECPP__COMMON__CRC_HH */
