dnl ---------------------------------------------------------------------
dnl  Check for existence of libbz2 library
dnl ---------------------------------------------------------------------
AC_DEFUN([AX_LDAS_CHECK_LIB_BZ2],
[ have_libbz2='yes'
  AC_CHECK_LIB(bz2,BZ2_bzBuffToBuffCompress,
  [ AC_DEFINE( HAVE_NEW_LIBZ2,1,[Defined if libz2 has new functions] ) ],
  [ AC_CHECK_LIB(bz2, bzBuffToBuffCompress,,
    [ if test -n "$1" && test "$1" = "no"
      then
        AC_MSG_WARN( Library libbz2 not found )
	have_libbz2=''
      else
        AC_MSG_ERROR( Required library libbz2 not found )
      fi
    ])
  ])
  AM_CONDITIONAL(HAVE_LIBBZ2, test x$have_libbz2 != x)
])
