#ifndef FrameCPP__VERSION_7__Specs_HH
#define FrameCPP__VERSION_7__Specs_HH

#include "ldastoolsal/types.hh"

#include "framecpp/Common/FrameSpec.hh"

#if defined(__cplusplus) && !defined(SWIG)
namespace FrameCPP
{
  namespace Common
  {
    class IStream;
    class OStream;
  }

  namespace Version_6 {}

  //---------------------------------------------------------------------
  /// \brief Implementation of the version 7 specification
  ///
  /// This namespace includes classes and functions needed to implement
  /// the version 4 frame specification as described by LIGO-T970130-G-E
  /// dated September 7, 2006.
  //---------------------------------------------------------------------
  namespace Version_7
  {
    using Common::IStream;
    using Common::OStream;

    namespace Previous = Version_6;

    const CHAR_U DATA_FORMAT_VERSION = 7;
    const CHAR_U LIBRARY_MINOR_VERSION = 1;

    bool init_frame_spec( );
  } // namespace - Version_7
} // namespace - FrameCPP

#endif /* defined(__cplusplus) && !defined(SWIG) */
#endif /* FrameCPP__VERSION_7__Specs_HH */
