/* -*- mode: c++ -*- */

#ifndef LDASframePythonI
#define LDASframePythonI

#if defined(SWIGPYTHON)

%{
  #include <wchar.h>

  #include "ldastoolsal/MemChecker.hh"

  extern "C" {
    void frameCPP_on_exit( )
    {
      LDASTools::AL::MemChecker::Trigger t( true );

      t.DoGarbageCollection( );
    }
  } /* extern "C" */
%}

%init %{
  Py_AtExit( frameCPP_on_exit );
%}

%exception
{
  //---------------------------------------------------------------------
  // Ensure that no exceptions leave the C++ layer
  //---------------------------------------------------------------------
  try
  {
    $action;
  }
  catch( const std::exception& Exception )
  {
    //-------------------------------------------------------------------
    // Handle exceptions derived from std::exception
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( Exception.what( ) ) );
    goto fail;
  }
  catch( ... )
  {
    //-------------------------------------------------------------------
    // Catch everything else to make sure they do not leak outside
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( "unknown error" ) );
    goto fail;
  }
}

%define LDAS_PROPERTY_READ_ONLY(Name,ReadFunc)
  %insert("python") %{
     __swig_getmethods__[Name] = ReadFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

%define LDAS_PROPERTY_READ_WRITE(Name,ReadFunc,WriteFunc)
  %insert("python") %{
    __swig_getmethods__[Name] = ReadFunc
    __swig_setmethods__[Name] = WriteFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

%typemap(in) swig_list_string_type {
  /* Check if is a list */
  if ( PyTuple_Check( $input ) )
  {
    const int size = PyTuple_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyTuple_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.push_back( PyString_AsString( PyTuple_GetItem( $input, i ) ) );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "tuple must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyList_Check( $input ) )
  {
    const int size = PyList_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyList_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.push_back( PyString_AsString( PyList_GetItem( $input, i ) ) );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "list must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyString_Check( $input ) )
  {
    $1.push_back( PyString_AsString( $input ) );
  }
  else
  {
    PyErr_SetString( PyExc_TypeError, "not a list or a string" );
    return NULL;
  }
}

%typemap(in) swig_vector_string_type {
  /* Check if is a list */
  if ( PyTuple_Check( $input ) )
  {
    const int size = PyTuple_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyTuple_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.push_back( PyString_AsString( PyTuple_GetItem( $input, i ) ) );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "tuple must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyList_Check( $input ) )
  {
    const int size = PyList_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyList_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.push_back( PyString_AsString( PyList_GetItem( $input, i ) ) );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "list must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyString_Check( $input ) )
  {
    $1.push_back( PyString_AsString( $input ) );
  }
  else
  {
    PyErr_SetString( PyExc_TypeError, "not a tuple, list or a string" );
    return NULL;
  }
}

%typemap(in) channel_container_type {
 /* Check if is a list */
  if ( PyTuple_Check( $input ) )
  {
    const int size = PyTuple_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyTuple_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.names.push_back( PyString_AsString( PyTuple_GetItem( $input, i ) ) );
	$1.resampling.push_back( 1 );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "tuple must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyList_Check( $input ) )
  {
    const int size = PyList_Size( $input );

    for ( int i = 0; i < size; i++ )
    {
      PyObject *o = PyList_GetItem( $input, i );
      if ( PyString_Check( o ) )
      {
	$1.names.push_back( PyString_AsString( PyList_GetItem( $input, i ) ) );
	$1.resampling.push_back( 1 );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "list must contain strings" );
	return NULL;
      }
    }
  }
  else if ( PyString_Check( $input ) )
  {
    $1.names.push_back( PyString_AsString( $input ) );
    $1.resampling.push_back( 1 );
  }
  else
  {
    PyErr_SetString( PyExc_TypeError, "not a tuple, list or a string" );
    return NULL;
  }
}

%import frameAPI/LDASframe.i

#endif /* defined(SWIGPYTHON) */

#endif /* LDASframePythonI */
