#if HAVE_CONFIG_H
#include <diskcache_config.h>
#endif /* HAVE_CONFIG_H */

#include <iomanip>

#include "ldastoolsal/types.hh"

#include "ASCII.hh"

namespace diskCache
{
  namespace Streams
  {
    //===================================================================
    // OASCII
    //===================================================================
    OASCII::writer_container_type OASCII::m_writers;

    OASCII::
    OASCII( std::ostream& Sink, version_type Version )
      : OInterface( Version ),
	m_stream( Sink )
    {
      if ( Version >= VERSION_HEADER )
      {
	//---------------------------------------------------------------
	// Write the header block
	//---------------------------------------------------------------
	Sink << "# version: 0x"
	     << std::setfill('0') << std::setw(4) << std::hex << Version << std::dec
	     << std::endl
	  ;
      }
    } // method - OASCII::OASCII

    OASCII::
    ~OASCII( )
    {
    } // method - OASCII::~OASCII
  } // namespace - Streams
} // namespace - diskCache
