#ifndef GENERAL__DEAD_LOCK_DETECTOR_HH
#define GENERAL__DEAD_LOCK_DETECTOR_HH

#define DEAD_LOCK_DETECTOR_ENABLED 0

#if DEAD_LOCK_DETECTOR_ENABLED

#include <list>

#if DEAD_LOCK_DETECTOR_USES_UNORDERED_MAP
#include "ldastoolsal/unordered_map.hh"
#else /* DEAD_LOCK_DETECTOR_USES_UNORDERED_MAP */
#include <map>
#endif /* DEAD_LOCK_DETECTOR_USES_UNORDERED_MAP */

#include "ldastoolsal/gpstime.hh"
#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/ReadWriteLock.hh"

namespace LDASTools
{
  namespace AL
  {
    class DeadLockDetector
    {
    public:
      typedef pthread_t thread_type;
      typedef enum {
	MUTEX,
	RW_READ,
	RW_WRITE,
	UNSPECIFIED
      } lock_class_type;

      typedef enum {
	INITIALIZED,
	PENDING,
	ACQUIRED,
	RELEASED,
	ACQUISITION_ERROR
      } state_type;

      struct state_info_type {
	lock_class_type		s_lock_type;
	state_type 		s_state;
	void*			s_lock;
	int			s_error;
	const char*		s_filename;
	unsigned int		s_linenumber;

	state_info_type( void*		LockPtr,
			 lock_class_type	LockType,
			 state_type	LockState,
			 const char*	Filename,
			 int		LineNumber )
	  : s_lock_type( LockType ),
	    s_state( LockState ),
	    s_lock( LockPtr ),
	    s_filename( Filename ),
	    s_linenumber( LineNumber )
	{
	
	}
		       
      };

      static void Dump( );

      static std::ostream& DumpWithoutLocking( std::ostream& Stream = std::cerr );

      static int SetDebugging( int Value );

      static void SetState( lock_class_type Lock,
			    MutexLock::baton_type MutexPtr,
			    state_type State,
			    const char* Filename = "",
			    unsigned int LineNum = 0 );

      static void SetState( state_info_type& Info );

#if HAVE_PTHREAD_RW_LOCK
      static void SetState( lock_class_type Lock,
			    ReadWriteLock::baton_type LockPtr,
			    state_type State,
			    const char* Filename = "",
			    unsigned int LineNum = 0 );
#endif /* HAVE_PTHREAD_RW_LOCK */

      static void ThreadRegister( thread_type Thread, const std::string& Desc = "" );

      static void ThreadUnregister( thread_type Thread );

    private:
      static void set_state( state_info_type& Info );

    };


    inline void DeadLockDetector::
    SetState( state_info_type& Info )
    {
      set_state( Info );
    }

  } // namespace - AL
} // namespace - LDASTools
#endif /* DEAD_LOCK_DETECTOR_ENABLED */
#endif /* GENERAL__DEAD_LOCK_DETECTOR_HH */
