/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.formimpl;

import com.formdev.flatlaf.FlatLightLaf;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import net.sf.launch4j.Builder;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.FileChooserFilter;
import net.sf.launch4j.Log;
import net.sf.launch4j.Main;
import net.sf.launch4j.Util;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.ConfigPersisterException;
import net.sf.launch4j.formimpl.ConfigFormImpl;
import net.sf.launch4j.formimpl.FileChooser;
import net.sf.launch4j.formimpl.GlassPane;
import net.sf.launch4j.formimpl.Messages;

public class MainFrame
extends JFrame {
    private static MainFrame _instance;
    private final JToolBar _toolBar;
    private final JButton _runButton;
    private final ConfigFormImpl _configForm;
    private final JFileChooser _fileChooser = new FileChooser(MainFrame.class);
    private File _outfile;
    private boolean _saved = false;

    public static void createInstance() {
        try {
            FlatLightLaf.install();
            _instance = new MainFrame();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static MainFrame getInstance() {
        return _instance;
    }

    public MainFrame() {
        this.showConfigName(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MainFrameListener());
        this.setGlassPane(new GlassPane(this));
        this._fileChooser.setFileFilter(new FileChooserFilter(Messages.getString("MainFrame.config.files"), new String[]{".xml", ".cfg"}));
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setRollover(true);
        this.addButton(UIManager.getIcon("Tree.leafIcon"), Messages.getString("MainFrame.new.config"), new NewActionListener());
        this.addButton(UIManager.getIcon("Tree.openIcon"), Messages.getString("MainFrame.open.config"), new OpenActionListener());
        this.addButton(UIManager.getIcon("FileView.floppyDriveIcon"), Messages.getString("MainFrame.save.config"), new SaveActionListener());
        this._toolBar.addSeparator();
        this.addButton(this.getLocalIcon("images/build.png"), Messages.getString("MainFrame.build.wrapper"), new BuildActionListener());
        this._runButton = this.addButton(this.getLocalIcon("images/run.png"), Messages.getString("MainFrame.test.wrapper"), new RunActionListener());
        this.setRunEnabled(false);
        this._toolBar.addSeparator();
        this.addButton(UIManager.getIcon("HelpButton.icon"), Messages.getString("MainFrame.about.launch4j"), new AboutActionListener());
        this._configForm = new ConfigFormImpl();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._toolBar, "North");
        this.getContentPane().add((Component)this._configForm, "Center");
        this.pack();
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension fr = this.getSize();
        fr.width = 900;
        fr.height += 100;
        this.setBounds((scr.width - fr.width) / 2, (scr.height - fr.height) / 2, fr.width, fr.height);
        this.setVisible(true);
    }

    private ImageIcon getLocalIcon(String iconPath) {
        return new ImageIcon(MainFrame.class.getClassLoader().getResource(iconPath));
    }

    private JButton addButton(Icon icon, String tooltip, ActionListener l) {
        JButton b = new JButton(icon);
        b.setToolTipText(tooltip);
        b.addActionListener(l);
        this._toolBar.add(b);
        return b;
    }

    public void info(String text) {
        JOptionPane.showMessageDialog(this, text, Main.getName(), 1);
    }

    public void warn(String text) {
        JOptionPane.showMessageDialog(this, text, Main.getName(), 2);
    }

    public void warn(InvariantViolationException e) {
        Binding b = e.getBinding();
        if (b != null) {
            b.markInvalid();
        }
        this.warn(e.getMessage());
        if (b != null) {
            e.getBinding().markValid();
        }
    }

    public boolean confirm(String text) {
        return JOptionPane.showConfirmDialog(this, text, Messages.getString("MainFrame.confirm"), 0) == 0;
    }

    private boolean canDiscardChanges() {
        return !this._configForm.isModified() || this.confirm(Messages.getString("MainFrame.discard.changes"));
    }

    private boolean save() {
        try {
            this._configForm.get(ConfigPersister.getInstance().getConfig());
            if (this._fileChooser.showSaveDialog(this) == 0) {
                File f = this._fileChooser.getSelectedFile();
                if (!f.getPath().endsWith(".xml")) {
                    f = new File(f.getPath() + ".xml");
                }
                ConfigPersister.getInstance().save(f);
                this._saved = true;
                this.showConfigName(f);
                return true;
            }
            return false;
        }
        catch (InvariantViolationException ex) {
            this.warn(ex);
            return false;
        }
        catch (BindingException ex) {
            this.warn(ex.getMessage());
            return false;
        }
        catch (ConfigPersisterException ex) {
            this.warn(ex.getMessage());
            return false;
        }
    }

    private void showConfigName(File config) {
        this.setTitle(Main.getName() + " - " + (config != null ? config.getName() : Messages.getString("MainFrame.untitled")));
    }

    private void setRunEnabled(boolean enabled) {
        if (!enabled) {
            this._outfile = null;
        }
        this._runButton.setEnabled(enabled);
    }

    private void clearConfig() {
        ConfigPersister.getInstance().createBlank();
        this._configForm.clear(ConfigPersister.getInstance().getConfig());
    }

    private class AboutActionListener
    implements ActionListener {
        private AboutActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.info(Main.getDescription());
        }
    }

    private class RunActionListener
    implements ActionListener {
        private RunActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MainFrame.this.getGlassPane().setVisible(true);
                Worker.post((Task)new Task(){

                    public Object run() throws ExecException {
                        Log log = Log.getSwingLog(MainFrame.this._configForm.getLogTextArea());
                        log.clear();
                        String path = MainFrame.this._outfile.getPath();
                        if (Util.WINDOWS_OS) {
                            log.append(Messages.getString("MainFrame.executing") + path);
                            Util.exec(new String[]{path, "--l4j-debug"}, log);
                        } else {
                            log.append(Messages.getString("MainFrame.jar.integrity.test") + path);
                            Util.exec(new String[]{"java", "-jar", path}, log);
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
            }
            finally {
                MainFrame.this.getGlassPane().setVisible(false);
            }
        }
    }

    private class BuildActionListener
    implements ActionListener {
        private BuildActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Log log = Log.getSwingLog(MainFrame.this._configForm.getLogTextArea());
            try {
                if (!(MainFrame.this._saved && !MainFrame.this._configForm.isModified() || MainFrame.this.save())) {
                    return;
                }
                log.clear();
                ConfigPersister.getInstance().getConfig().checkInvariants();
                Builder b = new Builder(log);
                MainFrame.this._outfile = b.build();
                MainFrame.this.setRunEnabled(ConfigPersister.getInstance().getConfig().isGuiApplication() && (Util.WINDOWS_OS || !ConfigPersister.getInstance().getConfig().isDontWrapJar()));
            }
            catch (InvariantViolationException ex) {
                MainFrame.this.setRunEnabled(false);
                ex.setBinding(MainFrame.this._configForm.getBinding(ex.getProperty()));
                MainFrame.this.warn(ex);
            }
            catch (BuilderException ex) {
                MainFrame.this.setRunEnabled(false);
                log.append(ex.getMessage());
            }
        }
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.save();
        }
    }

    private class OpenActionListener
    implements ActionListener {
        private OpenActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (MainFrame.this.canDiscardChanges() && MainFrame.this._fileChooser.showOpenDialog(MainFrame.this) == 0) {
                    File f = MainFrame.this._fileChooser.getSelectedFile();
                    if (f.getPath().endsWith(".xml")) {
                        ConfigPersister.getInstance().load(f);
                        MainFrame.this._saved = true;
                    } else {
                        ConfigPersister.getInstance().loadVersion1(f);
                        MainFrame.this._saved = false;
                    }
                    MainFrame.this._configForm.put(ConfigPersister.getInstance().getConfig());
                    MainFrame.this.showConfigName(f);
                    MainFrame.this.setRunEnabled(false);
                }
            }
            catch (ConfigPersisterException ex) {
                MainFrame.this.warn(ex.getMessage());
            }
            catch (BindingException ex) {
                MainFrame.this.warn(ex.getMessage());
            }
        }
    }

    private class NewActionListener
    implements ActionListener {
        private NewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.canDiscardChanges()) {
                MainFrame.this.clearConfig();
                MainFrame.this._saved = false;
                MainFrame.this.showConfigName(null);
                MainFrame.this.setRunEnabled(false);
            }
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            MainFrame.this.clearConfig();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (MainFrame.this.canDiscardChanges()) {
                MainFrame.this.dispose();
                System.exit(0);
            }
        }
    }
}

