/*
   Copyright 2009 Last.fm Ltd.
      - Primarily authored by Jono Cole

   This file is part of the Last.fm Desktop Application Suite.

   lastfm-desktop is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   lastfm-desktop is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with lastfm-desktop.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ANIMATED_PUSHBUTTON_H
#define ANIMATED_PUSHBUTTON_H

#include <QPushButton>
#include <QMovie>
#include <QDebug>
#include <iostream>
class AnimatedPushButton : public QPushButton
{
public:
    AnimatedPushButton( QMovie* movie, const QString& text, QWidget* parent = 0 )
    :QPushButton( text, parent ),
     m_movie( movie )
    {
        m_movie->start();
        setIcon(QIcon( m_movie->currentPixmap()));
        m_movie->stop();
    }

private:
    QMovie* m_movie;
};

#endif //ANIMATED_PUSHBUTTON_H
